<?php
function wr_divi_post_content()
{
    if (class_exists('ET_Builder_Module')) {

        class ET_Builder_Module_Post_Content extends ET_Builder_Module
        {
            function init()
            {
                $this->name = esc_html__('Post Content', 'et_builder');
                $this->slug = 'et_pb_post_content';
                $this->fb_support = true;
                $this->defaults = array();

                $this->whitelisted_fields = array(
                    'title',
                    'meta',
                    'author',
                    'date',
                    'date_format',
                    'categories',
                    'comments',
                    'featured_image',
                    'featured_placement',
                    'parallax_effect',
                    'parallax_method',
                    'background_size',
                    'background_position',
                    'background_repeat',
                    'background_blend',
                    'text_orientation',
                    'text_color',
                    'text_background',
                    'text_bg_color',
                    'module_bg_color',
                    'admin_label',
                    'module_id',
                    'module_class',
                );

                $this->fields_defaults = array(
                    'title' => array('on'),
                    'meta' => array('on'),
                    'author' => array('on'),
                    'date' => array('on'),
                    'date_format' => array('M j, Y'),
                    'categories' => array('on'),
                    'comments' => array('on'),
                    'featured_image' => array('on'),
                    'featured_placement' => array('below'),
                    'parallax_effect' => array('off'),
                    'parallax_method' => array('on'),
                    'text_orientation' => array('left'),
                    'text_color' => array('dark'),
                    'text_background' => array('off'),
                    'text_bg_color' => array('rgba(255,255,255,0.9)', 'only_default_setting'),
                );

                $this->main_css_element = '%%order_class%%';

                $this->options_toggles = array(
                    'general' => array(
                        'toggles' => array(
                            'elements' => esc_html__('Elements', 'et_builder'),
                            'background' => esc_html__('Background', 'et_builder'),
                        ),
                    ),
                    'advanced' => array(
                        'toggles' => array(
                            'text' => array(
                                'title' => esc_html__('Text', 'et_builder'),
                                'priority' => 49,
                            ),
                        ),
                    ),
                );

                $this->advanced_options = array(
                    'border' => array(
                        'css' => array(
                            'main' => "{$this->main_css_element}.et_pb_featured_bg, {$this->main_css_element}",
                        ),
                    ),
                    'custom_margin_padding' => array(
                        'css' => array(
                            'main' => ".et_pb_section {$this->main_css_element}.et_pb_post_title",
                            'important' => 'all',
                        ),
                    ),
                    'fonts' => array(
                        'title' => array(
                            'label' => esc_html__('Title', 'et_builder'),
                            'use_all_caps' => true,
                            'css' => array(
                                'main' => "{$this->main_css_element} .et_pb_title_container h1.entry-title",
                            ),
                        ),
                        'meta' => array(
                            'label' => esc_html__('Meta', 'et_builder'),
                            'css' => array(
                                'main' => "{$this->main_css_element} .et_pb_title_container .et_pb_title_meta_container, {$this->main_css_element} .et_pb_title_container .et_pb_title_meta_container a",
                                'plugin_main' => "{$this->main_css_element} .et_pb_title_container .et_pb_title_meta_container, {$this->main_css_element} .et_pb_title_container .et_pb_title_meta_container a, {$this->main_css_element} .et_pb_title_container .et_pb_title_meta_container span",
                            ),
                        ),
                    ),
                    'background' => array(
                        'use_background_color' => false,
                        'use_background_image' => false,
                        'use_background_color_gradient' => true,
                    ),
                );
                $this->custom_css_options = array(
                    'post_title' => array(
                        'label' => esc_html__('Title', 'et_builder'),
                        'selector' => 'h1',
                    ),
                    'post_meta' => array(
                        'label' => esc_html__('Meta', 'et_builder'),
                        'selector' => '.et_pb_title_meta_container',
                    ),
                    'post_image' => array(
                        'label' => esc_html__('Featured Image', 'et_builder'),
                        'selector' => '.et_pb_title_featured_container',
                    ),
                );
            }

            function get_fields()
            {
                $fields = array(
                    'title' => array(
                        'label' => esc_html__('Show Title', 'et_builder'),
                        'type' => 'yes_no_button',
                        'option_category' => 'configuration',
                        'options' => array(
                            'on' => esc_html__('Yes', 'et_builder'),
                            'off' => esc_html__('No', 'et_builder'),
                        ),
                        'toggle_slug' => 'elements',
                        'description' => esc_html__('Here you can choose whether or not display the Post Title', 'et_builder'),
                    ),
                    'meta' => array(
                        'label' => esc_html__('Show Meta', 'et_builder'),
                        'type' => 'yes_no_button',
                        'option_category' => 'configuration',
                        'options' => array(
                            'on' => esc_html__('Yes', 'et_builder'),
                            'off' => esc_html__('No', 'et_builder'),
                        ),
                        'affects' => array(
                            'author',
                            'date',
                            'categories',
                            'comments',
                        ),
                        'toggle_slug' => 'elements',
                        'description' => esc_html__('Here you can choose whether or not display the Post Meta', 'et_builder'),
                    ),
                    'author' => array(
                        'label' => esc_html__('Show Author', 'et_builder'),
                        'type' => 'yes_no_button',
                        'option_category' => 'configuration',
                        'options' => array(
                            'on' => esc_html__('Yes', 'et_builder'),
                            'off' => esc_html__('No', 'et_builder'),
                        ),
                        'depends_show_if' => 'on',
                        'toggle_slug' => 'elements',
                        'description' => esc_html__('Here you can choose whether or not display the Author Name in Post Meta', 'et_builder'),
                    ),
                    'date' => array(
                        'label' => esc_html__('Show Date', 'et_builder'),
                        'type' => 'yes_no_button',
                        'option_category' => 'configuration',
                        'options' => array(
                            'on' => esc_html__('Yes', 'et_builder'),
                            'off' => esc_html__('No', 'et_builder'),
                        ),
                        'depends_show_if' => 'on',
                        'affects' => array(
                            'date_format'
                        ),
                        'toggle_slug' => 'elements',
                        'description' => esc_html__('Here you can choose whether or not display the Date in Post Meta', 'et_builder'),
                    ),
                    'date_format' => array(
                        'label' => esc_html__('Date Format', 'et_builder'),
                        'type' => 'text',
                        'option_category' => 'configuration',
                        'depends_show_if' => 'on',
                        'toggle_slug' => 'elements',
                        'description' => esc_html__('Here you can define the Date Format in Post Meta. Default is \'M j, Y\'', 'et_builder'),
                    ),
                    'categories' => array(
                        'label' => esc_html__('Show Post Categories', 'et_builder'),
                        'type' => 'yes_no_button',
                        'option_category' => 'configuration',
                        'options' => array(
                            'on' => esc_html__('Yes', 'et_builder'),
                            'off' => esc_html__('No', 'et_builder'),
                        ),
                        'depends_show_if' => 'on',
                        'toggle_slug' => 'elements',
                        'description' => esc_html__('Here you can choose whether or not display the Categories in Post Meta. Note: This option doesn\'t work with custom post types.', 'et_builder'),
                    ),
                    'comments' => array(
                        'label' => esc_html__('Show Comments Count', 'et_builder'),
                        'type' => 'yes_no_button',
                        'option_category' => 'configuration',
                        'options' => array(
                            'on' => esc_html__('Yes', 'et_builder'),
                            'off' => esc_html__('No', 'et_builder'),
                        ),
                        'depends_show_if' => 'on',
                        'toggle_slug' => 'elements',
                        'description' => esc_html__('Here you can choose whether or not display the Comments Count in Post Meta.', 'et_builder'),
                    ),
                    'featured_image' => array(
                        'label' => esc_html__('Show Featured Image', 'et_builder'),
                        'type' => 'yes_no_button',
                        'option_category' => 'configuration',
                        'options' => array(
                            'on' => esc_html__('Yes', 'et_builder'),
                            'off' => esc_html__('No', 'et_builder'),
                        ),
                        'affects' => array(
                            'featured_placement',
                        ),
                        'toggle_slug' => 'elements',
                        'description' => esc_html__('Here you can choose whether or not display the Featured Image', 'et_builder'),
                    ),
                    'featured_placement' => array(
                        'label' => esc_html__('Featured Image Placement', 'et_builder'),
                        'type' => 'select',
                        'option_category' => 'configuration',
                        'options' => array(
                            'below' => esc_html__('Below Title', 'et_builder'),
                            'above' => esc_html__('Above Title', 'et_builder'),
                            'background' => esc_html__('Title/Meta Background Image', 'et_builder'),
                        ),
                        'depends_show_if' => 'on',
                        'affects' => array(
                            'parallax_effect',
                        ),
                        'toggle_slug' => 'elements',
                        'description' => esc_html__('Here you can choose where to place the Featured Image', 'et_builder'),
                    ),
                    'parallax_effect' => array(
                        'label' => esc_html__('Use Parallax Effect', 'et_builder'),
                        'type' => 'yes_no_button',
                        'option_category' => 'configuration',
                        'options' => array(
                            'on' => esc_html__('Yes', 'et_builder'),
                            'off' => esc_html__('No', 'et_builder'),
                        ),
                        'depends_show_if' => 'background',
                        'affects' => array(
                            'parallax_method',
                            'background_size',
                            'background_position',
                            'background_repeat',
                            'background_blend',
                        ),
                        'tab_slug' => 'general',
                        'toggle_slug' => 'background',
                        'description' => esc_html__('Here you can choose whether or not use parallax effect for the featured image', 'et_builder'),
                    ),
                    'parallax_method' => array(
                        'label' => esc_html__('Parallax Method', 'et_builder'),
                        'type' => 'select',
                        'option_category' => 'configuration',
                        'options' => array(
                            'on' => esc_html__('CSS', 'et_builder'),
                            'off' => esc_html__('True Parallax', 'et_builder'),
                        ),
                        'depends_show_if' => 'on',
                        'tab_slug' => 'general',
                        'toggle_slug' => 'background',
                        'description' => esc_html__('Here you can choose which parallax method to use for the featured image', 'et_builder'),
                    ),
                    'background_size' => array(
                        'label' => esc_html__('Background Image Size', 'et_builder'),
                        'type' => 'select',
                        'option_category' => 'layout',
                        'options' => array(
                            'cover' => esc_html__('Cover', 'et_builder'),
                            'contain' => esc_html__('Fit', 'et_builder'),
                            'initial' => esc_html__('Actual Size', 'et_builder'),
                        ),
                        'default' => 'cover',
                        'depends_show_if' => 'off',
                        'toggle_slug' => 'background',
                    ),
                    'background_position' => array(
                        'label' => esc_html__('Background Image Position', 'et_builder'),
                        'type' => 'select',
                        'option_category' => 'layout',
                        'options' => array(
                            'top_left' => esc_html__('Top Left', 'et_builder'),
                            'top_center' => esc_html__('Top Center', 'et_builder'),
                            'top_right' => esc_html__('Top Right', 'et_builder'),
                            'center_left' => esc_html__('Center Left', 'et_builder'),
                            'center' => esc_html__('Center', 'et_builder'),
                            'center_right' => esc_html__('Center Right', 'et_builder'),
                            'bottom_left' => esc_html__('Bottom Left', 'et_builder'),
                            'bottom_center' => esc_html__('Bottom Center', 'et_builder'),
                            'bottom_right' => esc_html__('Bottom Right', 'et_builder'),
                        ),
                        'default' => 'center',
                        'depends_show_if' => 'off',
                        'toggle_slug' => 'background',
                    ),
                    'background_repeat' => array(
                        'label' => esc_html__('Background Image Repeat', 'et_builder'),
                        'type' => 'select',
                        'option_category' => 'layout',
                        'options' => array(
                            'repeat' => esc_html__('Repeat', 'et_builder'),
                            'repeat-x' => esc_html__('Repeat X (horizontal)', 'et_builder'),
                            'repeat-y' => esc_html__('Repeat Y (vertical)', 'et_builder'),
                            'space' => esc_html__('Space', 'et_builder'),
                            'round' => esc_html__('Round', 'et_builder'),
                            'no-repeat' => esc_html__('No Repeat', 'et_builder'),
                        ),
                        'default' => 'no-repeat',
                        'depends_show_if' => 'off',
                        'toggle_slug' => 'background',
                    ),
                    'background_blend' => array(
                        'label' => esc_html__('Background Image Blend', 'et_builder'),
                        'type' => 'select',
                        'option_category' => 'layout',
                        'options' => array(
                            'normal' => esc_html__('Normal', 'et_builder'),
                            'multiply' => esc_html__('Multiply', 'et_builder'),
                            'screen' => esc_html__('Screen', 'et_builder'),
                            'overlay' => esc_html__('Overlay', 'et_builder'),
                            'darken' => esc_html__('Darken', 'et_builder'),
                            'lighten' => esc_html__('Lighten', 'et_builder'),
                            'color-dodge' => esc_html__('Color Dodge', 'et_builder'),
                            'color-burn' => esc_html__('Color Burn', 'et_builder'),
                            'hard-light' => esc_html__('Hard Light', 'et_builder'),
                            'soft-light' => esc_html__('Soft Light', 'et_builder'),
                            'difference' => esc_html__('Difference', 'et_builder'),
                            'exclusion' => esc_html__('Exclusion', 'et_builder'),
                            'hue' => esc_html__('Hue', 'et_builder'),
                            'saturation' => esc_html__('Saturation', 'et_builder'),
                            'color' => esc_html__('Color', 'et_builder'),
                            'luminosity' => esc_html__('Luminosity', 'et_builder'),
                        ),
                        'default' => 'normal',
                        'depends_show_if' => 'off',
                        'toggle_slug' => 'background',
                    ),
                    'text_orientation' => array(
                        'label' => esc_html__('Text Orientation', 'et_builder'),
                        'type' => 'select',
                        'option_category' => 'layout',
                        'options' => array(
                            'left' => esc_html__('Left', 'et_builder'),
                            'center' => esc_html__('Center', 'et_builder'),
                            'right' => esc_html__('Right', 'et_builder'),
                        ),
                        'tab_slug' => 'advanced',
                        'toggle_slug' => 'text',
                        'description' => esc_html__('Here you can choose the orientation for the Title/Meta text', 'et_builder'),
                    ),
                    'text_color' => array(
                        'label' => esc_html__('Text Color', 'et_builder'),
                        'type' => 'select',
                        'option_category' => 'color_option',
                        'options' => array(
                            'dark' => esc_html__('Dark', 'et_builder'),
                            'light' => esc_html__('Light', 'et_builder'),
                        ),
                        'tab_slug' => 'advanced',
                        'toggle_slug' => 'text',
                        'description' => esc_html__('Here you can choose the color for the Title/Meta text', 'et_builder'),
                    ),
                    'text_background' => array(
                        'label' => esc_html__('Use Text Background Color', 'et_builder'),
                        'type' => 'yes_no_button',
                        'option_category' => 'color_option',
                        'options' => array(
                            'off' => esc_html__('No', 'et_builder'),
                            'on' => esc_html__('Yes', 'et_builder'),
                        ),
                        'affects' => array(
                            'text_bg_color',
                        ),
                        'tab_slug' => 'advanced',
                        'toggle_slug' => 'text',
                        'description' => esc_html__('Here you can choose whether or not use the background color for the Title/Meta text', 'et_builder'),
                    ),
                    'text_bg_color' => array(
                        'label' => esc_html__('Text Background Color', 'et_builder'),
                        'type' => 'color-alpha',
                        'depends_show_if' => 'on',
                        'tab_slug' => 'advanced',
                        'toggle_slug' => 'text',
                    ),
                    'module_bg_color' => array(
                        'label' => esc_html__('Background Color', 'et_builder'),
                        'type' => 'color-alpha',
                        'custom_color' => true,
                        'toggle_slug' => 'background',
                    ),
                    'disabled_on' => array(
                        'label' => esc_html__('Disable on', 'et_builder'),
                        'type' => 'multiple_checkboxes',
                        'options' => array(
                            'phone' => esc_html__('Phone', 'et_builder'),
                            'tablet' => esc_html__('Tablet', 'et_builder'),
                            'desktop' => esc_html__('Desktop', 'et_builder'),
                        ),
                        'additional_att' => 'disable_on',
                        'option_category' => 'configuration',
                        'description' => esc_html__('This will disable the module on selected devices', 'et_builder'),
                        'tab_slug' => 'custom_css',
                        'toggle_slug' => 'visibility',
                    ),
                    'admin_label' => array(
                        'label' => esc_html__('Admin Label', 'et_builder'),
                        'type' => 'text',
                        'description' => esc_html__('This will change the label of the module in the builder for easy identification.', 'et_builder'),
                        'toggle_slug' => 'admin_label',
                    ),
                    'module_id' => array(
                        'label' => esc_html__('CSS ID', 'et_builder'),
                        'type' => 'text',
                        'option_category' => 'configuration',
                        'tab_slug' => 'custom_css',
                        'toggle_slug' => 'classes',
                        'option_class' => 'et_pb_custom_css_regular',
                    ),
                    'module_class' => array(
                        'label' => esc_html__('CSS Class', 'et_builder'),
                        'type' => 'text',
                        'option_category' => 'configuration',
                        'tab_slug' => 'custom_css',
                        'toggle_slug' => 'classes',
                        'option_class' => 'et_pb_custom_css_regular',
                    ),
                );

                return $fields;
            }

            function shortcode_callback($atts, $content = null, $function_name)
            {
                $module_id = $this->shortcode_atts['module_id'];
                $module_class = $this->shortcode_atts['module_class'];
                $title = $this->shortcode_atts['title'];
                $meta = $this->shortcode_atts['meta'];
                $author = $this->shortcode_atts['author'];
                $date = $this->shortcode_atts['date'];
                $date_format = $this->shortcode_atts['date_format'];
                $categories = $this->shortcode_atts['categories'];
                $comments = $this->shortcode_atts['comments'];
                $featured_image = $this->shortcode_atts['featured_image'];
                $featured_placement = $this->shortcode_atts['featured_placement'];
                $parallax_effect = $this->shortcode_atts['parallax_effect'];
                $parallax_method = $this->shortcode_atts['parallax_method'];
                $background_size = $this->shortcode_atts['background_size'];
                $background_position = $this->shortcode_atts['background_position'];
                $background_repeat = $this->shortcode_atts['background_repeat'];
                $background_blend = $this->shortcode_atts['background_blend'];
                $text_orientation = $this->shortcode_atts['text_orientation'];
                $text_color = $this->shortcode_atts['text_color'];
                $text_background = $this->shortcode_atts['text_background'];
                $text_bg_color = $this->shortcode_atts['text_bg_color'];
                $module_bg_color = $this->shortcode_atts['module_bg_color'];
                $use_background_color_gradient = $this->shortcode_atts['use_background_color_gradient'];
                $background_color_gradient_type = $this->shortcode_atts['background_color_gradient_type'];
                $background_color_gradient_direction = $this->shortcode_atts['background_color_gradient_direction'];
                $background_color_gradient_direction_radial = $this->shortcode_atts['background_color_gradient_direction_radial'];
                $background_color_gradient_start = $this->shortcode_atts['background_color_gradient_start'];
                $background_color_gradient_end = $this->shortcode_atts['background_color_gradient_end'];
                $background_color_gradient_start_position = $this->shortcode_atts['background_color_gradient_start_position'];
                $background_color_gradient_end_position = $this->shortcode_atts['background_color_gradient_end_position'];
                $background_images = array();

// display the shortcode only on singlular pages
                if (!is_singular()) {
                    return;
                }

                $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);
                $this->process_additional_options($function_name);

                $output = '';
                $featured_image_output = '';
                $parallax_background_contaier = '';

                if ('on' === $featured_image && ('above' === $featured_placement || 'below' === $featured_placement)) {
                    $featured_image_output = sprintf('<div class="et_pb_title_featured_container">%1$s</div>',
                        get_the_post_thumbnail(get_the_ID(), 'large')
                    );
                }

                if ('on' === $title) {
                    if (is_et_pb_preview() && isset($_POST['post_title']) && wp_verify_nonce($_POST['et_pb_preview_nonce'], 'et_pb_preview_nonce')) {
                        $post_title = sanitize_text_field(wp_unslash($_POST['post_title']));
                    } else {
                        $post_title = get_the_content();
                    }

                    $output .= $post_title;
                }

                if ('on' === $meta) {
                    $meta_array = array();
                    foreach (array('author', 'date', 'categories', 'comments') as $single_meta) {
                        if ('on' === $$single_meta && ('categories' !== $single_meta || ('categories' === $single_meta && is_singular('post')))) {
                            $meta_array[] = $single_meta;
                        }
                    }

                    $output .= sprintf('<p class="et_pb_title_meta_container">%1$s</p>',
                        et_pb_postinfo_meta($meta_array, $date_format, esc_html__('0 comments', 'et_builder'), esc_html__('1 comment', 'et_builder'), '% ' . esc_html__('comments', 'et_builder'))
                    );
                }

                if ('on' === $use_background_color_gradient) {
                    $has_background_gradient = true;

                    $background_images[] = $this->get_gradient(array(
                        'type' => $background_color_gradient_type,
                        'direction' => $background_color_gradient_direction,
                        'radial_direction' => $background_color_gradient_direction_radial,
                        'color_start' => $background_color_gradient_start,
                        'color_end' => $background_color_gradient_end,
                        'start_position' => $background_color_gradient_start_position,
                        'end_position' => $background_color_gradient_end_position,
                    ));
                }

                if ('on' === $featured_image && 'background' === $featured_placement) {
                    $featured_image_src = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');

                    if ('on' === $parallax_effect) {
                        $parallax_background_contaier = sprintf('<div class="et_parallax_bg%1$s"></div>',
                            'on' === $parallax_method ? ' et_pb_parallax_css' : ''
                        );

                        ET_Builder_Element::set_style($function_name, array(
                            'selector' => '%%order_class%%.et_pb_featured_bg .et_parallax_bg',
                            'declaration' => sprintf(
                                'background-image: url("%1$s");',
                                esc_url($featured_image_src[0])
                            ),
                        ));
                    } else {
                        $has_background_image = true;

                        $background_images[] = sprintf(
                            'url(%1$s)',
                            esc_url($featured_image_src[0])
                        );

                        if ('' !== $background_size) {
                            ET_Builder_Element::set_style($function_name, array(
                                'selector' => '%%order_class%%.et_pb_featured_bg',
                                'declaration' => sprintf(
                                    'background-size: %1$s;',
                                    esc_html($background_size)
                                ),
                            ));
                        }

                        if ('' !== $background_position) {
                            $processed_position = str_replace('_', ' ', $background_position);

                            ET_Builder_Element::set_style($function_name, array(
                                'selector' => '%%order_class%%.et_pb_featured_bg',
                                'declaration' => sprintf(
                                    'background-position: %1$s;',
                                    esc_html($processed_position)
                                ),
                            ));
                        }

                        if ('' !== $background_repeat) {
                            ET_Builder_Element::set_style($function_name, array(
                                'selector' => '%%order_class%%.et_pb_featured_bg',
                                'declaration' => sprintf(
                                    'background-repeat: %1$s;',
                                    esc_html($background_repeat)
                                ),
                            ));
                        }

                        if ('' !== $background_blend) {
                            ET_Builder_Element::set_style($function_name, array(
                                'selector' => '%%order_class%%.et_pb_featured_bg',
                                'declaration' => sprintf(
                                    'background-blend-mode: %1$s;',
                                    esc_html($background_blend)
                                ),
                            ));
                        }
                    }
                }

                if (!empty($background_images)) {
                    $background_images = array_reverse($background_images);

                    ET_Builder_Element::set_style($function_name, array(
                        'selector' => 'background' === $featured_placement ? '%%order_class%%.et_pb_featured_bg' : '%%order_class%%',
                        'declaration' => sprintf(
                            'background-image: %1$s;',
                            esc_html(join(', ', $background_images))
                        ),
                    ));
                }

                if ('on' === $text_background) {
                    ET_Builder_Element::set_style($function_name, array(
                        'selector' => '%%order_class%% .et_pb_title_container',
                        'declaration' => sprintf(
                            'background-color: %1$s; padding: 1em 1.5em;',
                            esc_html($text_bg_color)
                        ),
                    ));
                }

                ET_Builder_Element::set_style($function_name, array(
                    'selector' => '%%order_class%%',
                    'declaration' => sprintf(
                        'text-align: %1$s;',
                        esc_html($text_orientation)
                    ),
                ));

                $video_background = $this->video_background();

                $background_layout = 'dark' === $text_color ? 'light' : 'dark';
                $module_class .= ' et_pb_bg_layout_' . $background_layout;

                if (!isset ($has_background_image, $has_background_gradient)) {
                    ET_Builder_Element::set_style($function_name, array(
                        'selector' => '%%order_class%%',
                        'declaration' => sprintf(
                            'background-color: %1$s;',
                            esc_html($module_bg_color)
                        ),
                    ));
                } else {
// Force background-color: initial
                    ET_Builder_Element::set_style($function_name, array(
                        'selector' => '%%order_class%%',
                        'declaration' => 'background-color: initial;',
                    ));
                }

                $output = sprintf(
                    '<div%3$s class="et_pb_module et_pb_post_title %2$s%4$s%8$s">
%5$s
%9$s
%6$s
<div class="et_pb_title_container">
    %1$s
</div>
%7$s
</div>',
                    $output,
                    ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
                    ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
                    'on' === $featured_image && 'background' === $featured_placement ? ' et_pb_featured_bg' : '',
                    $parallax_background_contaier,
                    'on' === $featured_image && 'above' === $featured_placement ? $featured_image_output : '',
                    'on' === $featured_image && 'below' === $featured_placement ? $featured_image_output : '',
                    '' !== $video_background ? ' et_pb_section_video et_pb_preload' : '',
                    $video_background

                );

                return $output;
            }
        }

        new ET_Builder_Module_Post_Content;
    }
}