<?php
/* Template Name: Accueil */
get_header();

$is_page_builder_used = et_pb_is_pagebuilder_used( get_the_ID() );

?>

	<div class="page_container">
		<div id="main-content">

			<?php if ( ! $is_page_builder_used ) : ?>

			<div class="container">
				<div id="content-area" class="clearfix">


					<?php endif; ?>

					<?php while ( have_posts() ) : the_post(); ?>

						<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

							<?php if ( ! $is_page_builder_used ) : ?>

								<h1 class="entry-title main_title"><?php the_title(); ?></h1>
								<?php
								$thumb = '';

								$width = (int) apply_filters( 'et_pb_index_blog_image_width', 1080 );

								$height = (int) apply_filters( 'et_pb_index_blog_image_height', 675 );
								$classtext = 'et_featured_image';
								$titletext = get_the_title();
								$thumbnail = get_thumbnail( $width, $height, $classtext, $titletext, $titletext, false, 'Blogimage' );
								$thumb = $thumbnail["thumb"];

								if ( 'on' === et_get_option( 'divi_page_thumbnails', 'false' ) && '' !== $thumb )
									print_thumbnail( $thumb, $thumbnail["use_timthumb"], $titletext, $width, $height );
								?>

							<?php endif; ?>

							<div class="entry-content">
								<?php
								the_content();

								if ( ! $is_page_builder_used )
									wp_link_pages( array( 'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'Divi' ), 'after' => '</div>' ) );
								?>
							</div> <!-- .entry-content -->

							<?php
							if ( ! $is_page_builder_used && comments_open() && 'on' === et_get_option( 'divi_show_pagescomments', 'false' ) ) comments_template( '', true );
							?>

						</article> <!-- .et_pb_post -->

					<?php endwhile; ?>

					<?php if ( ! $is_page_builder_used ) : ?>


				</div> <!-- #content-area -->
			</div> <!-- .container -->

		<?php endif; ?>
			<!-- Gammes footer pied de page -->
			<div class="container_gamme_home">
				<div class="et_pb_section et_pb_inner_shadow  et_pb_section_5 et_pb_with_background et_section_regular">
					<div class=" et_pb_row et_pb_row_7">

						<div class="et_pb_text et_pb_module et_pb_bg_layout_light et_pb_text_align_center pink et_pb_text_6">
							<div class="et_pb_text_inner title">
								<h2 style="text-align: center;">Découvrez nos gammes de spas</h2>
							</div>
						</div>
						<div class="et_pb_text et_pb_module et_pb_bg_layout_light et_pb_text_align_left  et_pb_text_7">
							<div class="et_pb_text_inner subtitle">
								<p style="text-align: center;">Venez découvrir le showroom de 120 m² où sont exposés les modèles.</p>
							</div>
						</div>
						<div class="et_pb_portfolio_grid clearfix et_pb_dpblog_portfolio_0">
							<?php
							$args = array(
								'depth'               => 1,
								'echo'                => 0,
								'hide_title_if_empty' => true,
								'hierarchical'        => true,
								'order'               => 'DESC',
								'orderby'             => 'name',
								//'style'               => 'list',
								'taxonomy'            => 'gammes',
								'title_li'            => '',
								'use_desc_for_title'  => 0,
							);
							//$gammes_list = wp_list_categories($args);
							$gammes_list = get_categories($args);

							foreach ($gammes_list as $gamme) {
								$cover = get_field('img_gamme', 'gammes_'.$gamme->term_id);
								?>
								<div class="et_pb_portfolio_item">
								<span class="et_portfolio_image">
									<img src="<?php echo $cover[0]['img']; ?>" alt="<?php echo $gamme->name; ?>" width="100%">
									<span class="et_overlay et_pb_inline_icon" data-icon="P"></span>
								</span>
								<h2><?php echo $gamme->name; ?></h2>
								<div class="post-excerpt">
									<?php the_field('txt_gamme', 'gammes_'.$gamme->term_id); ?>
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>gammes/<?php echo $gamme->slug; ?>" title="<?php echo $gamme->name; ?>" class="more-link">
										<i class="arrow_carrot-right_alt2"></i> lire la suite
									</a>
								</div>
							</div>
							<?php } ?>
						</div>


					</div>
				</div>
			</div>
			<!-- Marques produits dans le footer -->
			<?php echo do_shortcode('[et_pb_section global_module="1628"][/et_pb_section]'); ?>

		</div> <!-- #main-content -->
	</div>

<?php get_footer(); ?>