<?php

// Bootstrap
add_action( 'wp_enqueue_scripts', 'theme_enqueue_bootstrap' );
function theme_enqueue_bootstrap() {
    wp_enqueue_script( 'bootstrap-script', get_theme_file_uri() . '/js/bootstrap.min.js');
    wp_enqueue_style( 'bootstrap-style', get_theme_file_uri() . '/css/bootstrap.min.css' );
}

// Taille excerpt
function new_excerpt_length($length) {
    return 20;
}
add_filter('excerpt_length', 'new_excerpt_length');




add_action( 'wp_enqueue_scripts', 'theme_enqueue_responsive', 99);
function theme_enqueue_responsive() {
    wp_enqueue_style( 'wr-responsive', get_theme_file_uri() . '/css/responsive.css' );
}

if ( ! function_exists( 'et_get_original_footer_credits' ) ) :
    function et_get_original_footer_credits() {
        return sprintf( __( '&copy; 2017 %1$s  %2$s', 'bullesdereves' ), '<a href="http://www.bullesdereves90.com/" title="Bulles de rêves">Bulles de rêves</a>', '' );
    }
endif;

if ( ! function_exists( 'et_get_footer_credits' ) ) :
    function et_get_footer_credits() {
        $original_footer_credits = et_get_original_footer_credits();

        $disable_custom_credits = et_get_option( 'disable_custom_footer_credits', false );

        if ( $disable_custom_credits ) {
            return '';
        }

        $credits_format = '<%2$s id="footer-info">%1$s</%2$s>';
        $credits_format = '<%2$s id="footer-info">%1$s</%2$s>';

        $footer_credits = et_get_option( 'custom_footer_credits', '' );

        if ( '' === trim( $footer_credits ) ) {
            return et_get_safe_localization( sprintf( $credits_format, $original_footer_credits, 'p' ) );
        }

        return et_get_safe_localization( sprintf( $credits_format, $footer_credits, 'div' ) );
    }
endif;


/**
 * Ajouter une page d'options
 */
if( function_exists('acf_add_options_page') ) {
    acf_add_options_page();
}

/**
 * Function affichage.
 */
function p($variable){
    echo "<pre>";
    print_r($variable);
    echo "</pre>";
}

/**
 * Shortcode to show the module
 */
function showmodule_shortcode($moduleid) {
    extract(shortcode_atts(array('id' =>'*'),$moduleid));
    return do_shortcode('[et_pb_section global_module="'.$id.'"][/et_pb_section]');
}
add_shortcode('showmodule', 'showmodule_shortcode');



/**
 * Ajouter un type de contenu
 */
function wpm_custom_post_type() {

    //--------- POST TYPE PRODUIT ---------//
    $labels = array(
        // Le nom au pluriel
        'name'                => _x( 'Produits', 'Post Type General Name'),
        // Le nom au singulier
        'singular_name'       => _x( 'Produit', 'Post Type Singular Name'),
        // Le libellé affiché dans le menu
        'menu_name'           => __( 'Produits'),
        // Les différents libellés de l'administration
        'all_items'           => __( 'Tous les produits'),
        'view_item'           => __( 'Voir les produits'),
        'add_new_item'        => __( 'Ajouter un nouveau produit'),
        'add_new'             => __( 'Ajouter'),
        'edit_item'           => __( 'Editer le produit'),
        'update_item'         => __( 'Modifier le produit'),
        'search_items'        => __( 'Rechercher un produit'),
        'not_found'           => __( 'Non trouvé'),
        'not_found_in_trash'  => __( 'Non trouvé dans la corbeille'),
    );

    // On peut définir ici d'autres options pour notre custom post type

    $args = array(
        'label'               => __( 'Produits'),
        'description'         => __( 'Tous sur produits'),
        'labels'              => $labels,
        // On définit les options disponibles dans l'éditeur de notre custom post type ( un titre, un auteur...)
        'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
        /*
        * Différentes options supplémentaires
        */
        'hierarchical'        => false,
        'public'              => true,
        'has_archive'         => true,
        'menu_icon' => 'dashicons-tag',
        'rewrite'			  => array( 'slug' => 'produit'),

    );

    // On enregistre notre custom post type et ses arguments
    register_post_type( 'produit', $args );


    //--------- POST TYPE SPAS ---------//
    $labels = array(
        // Le nom au pluriel
        'name'                => _x( 'Spas', 'Post Type General Name'),
        // Le nom au singulier
        'singular_name'       => _x( 'Spa', 'Post Type Singular Name'),
        // Le libellé affiché dans le menu
        'menu_name'           => __( 'Spas'),
        // Les différents libellés de l'administration
        'all_items'           => __( 'Tous les spas'),
        'view_item'           => __( 'Voir les spas'),
        'add_new_item'        => __( 'Ajouter un nouveau spa'),
        'add_new'             => __( 'Ajouter'),
        'edit_item'           => __( 'Editer le spa'),
        'update_item'         => __( 'Modifier le spa'),
        'search_items'        => __( 'Rechercher un spa'),
        'not_found'           => __( 'Non trouvé'),
        'not_found_in_trash'  => __( 'Non trouvé dans la corbeille'),
    );

    // On peut définir ici d'autres options pour notre custom post type

    $args = array(
        'label'               => __( 'Spas'),
        'description'         => __( 'Tous sur spas'),
        'labels'              => $labels,
        // On définit les options disponibles dans l'éditeur de notre custom post type ( un titre, un auteur...)
        'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
        /*
        * Différentes options supplémentaires
        */
        'hierarchical'        => false,
        'public'              => true,
        'has_archive'         => true,
        'rewrite'			  => array( 'slug' => 'spas'),

    );

    // On enregistre notre custom post type et ses arguments
    register_post_type( 'spas', $args );

}

add_action( 'init', 'wpm_custom_post_type', 0 );

/**
 * Ajouter une taxonomy
 */
add_action( 'init', 'wpm_add_taxonomies', 0 );

function wpm_add_taxonomies() {

    // Taxonomie catégorie de produit
    $labels_categories = array(
        'name'                       => _x( 'Catégories', 'taxonomy general name'),
        'singular_name'              => _x( 'Catégorie', 'taxonomy singular name'),
        'search_items'               => __( 'Rechercher une catégorie de produit'),
        'popular_items'              => __( 'Catégories de produit populaires'),
        'all_items'                  => __( 'Toutes les catégories de produits'),
        'edit_item'                  => __( 'Editer une catégorie de produits'),
        'update_item'                => __( 'Mettre à jour une catégorie de produits'),
        'add_new_item'               => __( 'Ajouter une nouvelle catégorie de produits'),
        'new_item_name'              => __( 'Nom de la nouvelle catégorie de produits'),
        'separate_items_with_commas' => __( 'Séparer les catégories de produits avec une virgule'),
        'add_or_remove_items'        => __( 'Ajouter ou supprimer une catégorie de produit'),
        'choose_from_most_used'      => __( 'Choisir parmi les plus utilisés'),
        'not_found'                  => __( 'Pas de catégorie de produit trouvée'),
        'menu_name'                  => __( 'Catégories'),
    );

    $args_categories = array(
        'hierarchical'          => true,
        'labels'                => $labels_categories,
        'show_ui'               => true,
        'show_admin_column'     => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var'             => true,
        'rewrite'               => array( 'slug' => 'produit-piscine' ),
    );

    register_taxonomy( 'categories', 'produit', $args_categories );



    // Taxonomie gamme
    $labels_spa = array(
        'name'                       => _x( 'Gammes', 'taxonomy general name'),
        'singular_name'              => _x( 'Gamme', 'taxonomy singular name'),
        'search_items'               => __( 'Rechercher une gamme'),
        'popular_items'              => __( 'Gammes populaires'),
        'all_items'                  => __( 'Toutes les gammes'),
        'edit_item'                  => __( 'Editer une gamme'),
        'update_item'                => __( 'Mettre à jour une gamme'),
        'add_new_item'               => __( 'Ajouter une nouvelle gamme'),
        'new_item_name'              => __( 'Nom de la nouvelle gamme'),
        'separate_items_with_commas' => __( 'Séparer les gammes avec une virgule'),
        'add_or_remove_items'        => __( 'Ajouter ou supprimer une gamme'),
        'choose_from_most_used'      => __( 'Choisir parmi les plus utilisés'),
        'not_found'                  => __( 'Pas de gamme trouvée'),
        'menu_name'                  => __( 'Gammes'),
    );

    $args_spa = array(
        'hierarchical'          => true,
        'labels'                => $labels_spa,
        'show_ui'               => true,
        'show_admin_column'     => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var'             => true,
        'rewrite'               => array( 'slug' => 'gammes' ),
    );

    register_taxonomy( 'gammes', 'spas', $args_spa );

}

include(get_stylesheet_directory() . '/wr_divi_post_content.php');
include(get_stylesheet_directory() . '/wr_divi_post_excerpt.php');
add_action('et_builder_ready', 'wr_divi_post_content');
add_action('et_builder_ready', 'wr_divi_post_excerpt');

function admin_css() {
    $admin_handle = 'admin_css';
    $admin_stylesheet = get_theme_file_uri() . '/css/webrelief.css';

    wp_enqueue_style( $admin_handle, $admin_stylesheet );
}
add_action('admin_print_styles', 'admin_css', 11 );