<?php
if (class_exists('ET_Builder_Module')) {//IF Divi Theme activated

    class ET_Builder_Module_DP_Blog_Portfolio extends ET_Builder_Module {

        private $terms_array;

        function init() {
            $this->name = __('DP Blog Portfolio', 'et_builder');
            $this->slug = 'et_pb_dpblog_portfolio';

            $this->terms_array = dp_ppp_terms_array();

            $this->whitelisted_fields = array(
                'fullwidth',
                'posts_number',
                'offset_number',
                'orderby',
                'order',
                'include_tags',
                'exclude_tags',
                'custom_query',
                'custom_post_types',
                'include_categories',
                'show_title',
                'lightbox',
                'popup',
                'custom_url',
                'custom_url_field_name',
                'url_new_window',
                'custom_fields',
                'custom_field_names',
                'custom_field_labels',
                'show_categories',
                'show_date',
                'show_excerpt',
                'excerpt_limit',
                'show_more',
                'show_pagination',
                'background_layout',
                'admin_label',
                'module_id',
                'module_class',
                'zoom_icon_color',
                'hover_overlay_color',
                'hover_icon',
            );

            $this->fields_defaults = array(
                'fullwidth' => array('on'),
                'posts_number' => array(10, 'add_default_setting'),
                'custom_query' => array('off'),
                'orderby' => array('date'),
                'order' => array('DESC'),
                'show_title' => array('on'),
                'lightbox' => array('off'),
                'popup' => array('off'),
                'custom_url' => array('off'),
                'url_new_window' => array('off'),
                'custom_fields' => array('off'),
                'show_categories' => array('on'),
                'show_date' => array('off'),
                'show_excerpt' => array('off'),
                'excerpt_limit' => array(140, 'add_default_setting'),
                'show_more' => array('off'),
                'show_pagination' => array('on'),
                'background_layout' => array('light'),
                'custom_post_types' => array('post', 'add_default_setting'),
            );

            $this->main_css_element = '%%order_class%% .et_pb_portfolio_item';

            $this->advanced_options = array(
                'fonts' => array(
                    'title' => array(
                        'label' => __('Title', 'et_builder'),
                        'css' => array(
                            'main' => "{$this->main_css_element} h2",
                            'important' => 'all',
                        ),
                    ),
                    'caption' => array(
                        'label' => __('Caption', 'et_builder'),
                        'css' => array(
                            'main' => "{$this->main_css_element} .post-meta",
                        ),
                    ),
                ),
                'background' => array(
                    'settings' => array(
                        'color' => 'alpha',
                    ),
                ),
                'border' => array(),
            );

            $this->custom_css_options = array(
                'portfolio_image' => array(
                    'label' => __('Portfolio Image', 'et_builder'),
                    'selector' => '.et_portfolio_image',
                ),
                'overlay' => array(
                    'label' => __('Overlay', 'et_builder'),
                    'selector' => '.et_overlay',
                ),
                'overlay_icon' => array(
                    'label' => __('Overlay Icon', 'et_builder'),
                    'selector' => '.et_overlay:before',
                ),
                'portfolio_title' => array(
                    'label' => __('Portfolio Title', 'et_builder'),
                    'selector' => '.et_pb_portfolio_item h2',
                ),
                'portfolio_post_meta' => array(
                    'label' => __('Portfolio Post Meta', 'et_builder'),
                    'selector' => '.et_pb_portfolio_item .post-meta',
                ),
            );
        }

        function get_fields() {
            $fields = array(
                'fullwidth' => array(
                    'label' => __('Layout', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'layout',
                    'options' => array(
                        'on' => __('Fullwidth', 'et_builder'),
                        'off' => __('Grid', 'et_builder'),
                        'list' => __('List', 'et_builder'),
                    ),
                    'description' => __('Choose your desired portfolio layout style.', 'et_builder'),
                ),
                'custom_query' => array(
                    'label' => __('Custom Query', 'et_builder'),
                    'type' => 'yes_no_button',
                    'option_category' => 'configuration',
                    'options' => array(
                        'off' => __('No', 'et_builder'),
                        'on' => __('Yes', 'et_builder'),
                    ),
                    'default' => 'off',
                    'tab_slug' => 'general',
                    'toggle_slug' => 'content',
                    'description' => __('Turn this option on if you want to create a custom query that is not possible using the options below. Once this option is turned on, all Content options below will be ignored and the module will load the 10 most recent blog posts by default. You can override this query using the following filter in your child theme\'s functions.php file: <strong>dp_ppp_custom_query_args</strong>. For more information and to see an example, see demo at <a href="https://www.diviplugins.com/divi-custom-queries/" target="_blank">Divi Plugins</a>  ', 'et_builder'),
                ),
                'posts_number' => array(
                    'label' => __('Posts Number', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'description' => __('Define the number of projects that should be displayed per page.', 'et_builder'),
                ),
                'offset_number' => array(
                    'label' => __('Offset number', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'default' => '0',
                    'description' => __('Choose how many posts you would like to offset by', 'et_builder'),
                ),
                'orderby' => array(
                    'label' => __('Order By', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'configuration',
                    'options' => array(
                        'date' => __('Date', 'et_builder'),
                        'title' => __('Title', 'et_builder'),
                        'name' => __('Slug', 'et_builder'),
                        'rand' => __('Random', 'et_builder'),
                    ),
                    'description' => __('Choose how to sort posts', 'et_builder'),
                ),
                'order' => array(
                    'label' => __('Order', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'configuration',
                    'options' => array(
                        'ASC' => __('Asc', 'et_builder'),
                        'DESC' => __('Desc', 'et_builder'),
                    ),
                    'description' => __('Choose which order to display posts', 'et_builder'),
                ),
                'custom_post_types' => array(
                    'label' => __('Custom Post Type Name', 'et_builder'),
                    'option_category' => 'basic_option',
                    'renderer' => 'dp_ppp_custom_post_types_option',
                    'description' => __('Check which posts types you would like to include in the layout', 'et_builder'),
                ),
                'include_categories' => array(
                    'label' => __('Categories', 'et_builder'),
                    'option_category' => 'basic_option',
                    'renderer' => 'dp_ppp_categories_option',
                    'description' => __('Check which categories you would like to include in the layout', 'et_builder'),
                ),
                'include_tags' => array(
                    'label' => __('Include Tags (posts only)', 'et_builder'),
                    'type' => 'text',
                    'description' => __('Enter a single tag slug or a comma separated list of tag slugs. All posts in the categories above AND WITH these tags will load. Leave empty if you only want to filter using the categories above. Does not work with custom post types.', 'et_builder'),
                ),
                'exclude_tags' => array(
                    'label' => __('Exclude Tags (posts only)', 'et_builder'),
                    'type' => 'text',
                    'description' => __('Enter a single tag slug or a comma separated list of tag slugs. All posts in the categories above AND WITHOUT these tags will load. Leave empty if you only want to filter using the categories above.', 'et_builder'),
                ),
                'show_title' => array(
                    'label' => __('Show Title', 'et_builder'),
                    'type' => 'yes_no_button',
                    'option_category' => 'configuration',
                    'options' => array(
                        'on' => __('Yes', 'et_builder'),
                        'off' => __('No', 'et_builder'),
                    ),
                    'description' => __('Turn project titles on or off.', 'et_builder'),
                ),
                'lightbox' => array(
                    'label' => __('Open in Lightbox', 'et_builder'),
                    'type' => 'yes_no_button',
                    'options' => array(
                        'off' => __('No', 'et_builder'),
                        'on' => __('Yes', 'et_builder'),
                    ),
                    'description' => __('Image opens in lightbox instead of opening blog post.', 'et_builder'),
                ),
                'popup' => array(
                    'label' => __('Show post in popup', 'et_builder'),
                    'type' => 'yes_no_button',
                    'options' => array(
                        'off' => __('No', 'et_builder'),
                        'on' => __('Yes', 'et_builder'),
                    ),
                    'description' => __('Posts open in popup instead of opening blog post.', 'et_builder'),
                ),
                'custom_url' => array(
                    'label' => __('Use Custom URLs', 'et_builder'),
                    'type' => 'yes_no_button',
                    'option_category' => 'configuration',
                    'options' => array(
                        'off' => __('No', 'et_builder'),
                        'on' => __('Yes', 'et_builder'),
                    ),
                    'affects' => array(
                        '#et_pb_custom_url_field_name',
                    ),
                    'description' => __('Changes the URL to a custom field value set in each post.', 'et_builder'),
                ),
                'custom_url_field_name' => array(
                    'label' => __('Custom Field for URL', 'et_builder'),
                    'type' => 'text',
                    'description' => __('Enter custom field name (NOT the URL). The URL value needs to be set in each post using the custom field you input here. If no value is set, defaults to post URL.', 'et_builder'),
                ),
                'url_new_window' => array(
                    'label' => esc_html__('Url Opens', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'configuration',
                    'options' => array(
                        'off' => esc_html__('In The Same Window', 'et_builder'),
                        'on' => esc_html__('In The New Tab', 'et_builder'),
                    ),
                    'default' => 'off',
                    'description' => esc_html__('Here you can choose whether or not your link opens in a new window', 'et_builder'),
                ),
                'custom_fields' => array(
                    'label' => __('Show Custom Fields', 'et_builder'),
                    'type' => 'yes_no_button',
                    'option_category' => 'configuration',
                    'options' => array(
                        'off' => __('No', 'et_builder'),
                        'on' => __('Yes', 'et_builder'),
                    ),
                    'affects' => array(
                        '#et_pb_custom_field_names',
                        '#et_pb_custom_field_labels',
                    ),
                    'description' => __('Displays custom fields set in each post.', 'et_builder'),
                ),
                'custom_field_names' => array(
                    'label' => __('Custom Field Names', 'et_builder'),
                    'type' => 'text',
                    'description' => __('Enter a single custom field name or a comma separated list of names.', 'et_builder'),
                ),
                'custom_field_labels' => array(
                    'label' => __('Custom Field Labels', 'et_builder'),
                    'type' => 'text',
                    'description' => __('Enter custom field label (including separator and spaces) or a comma separated list of labels in the same order as the names above. The number of labels must equal the number of names above, otherwise the name above will be used as the label for each custom field. For more information, see demo at <a href="http://www.diviplugins.com/portfolio-posts-pro-plugin/">Divi Plugins</a>', 'et_builder'),
                ),
                'show_categories' => array(
                    'label' => __('Show Categories', 'et_builder'),
                    'type' => 'yes_no_button',
                    'option_category' => 'configuration',
                    'options' => array(
                        'on' => __('Yes', 'et_builder'),
                        'off' => __('No', 'et_builder'),
                    ),
                    'description' => __('Turn the category links on or off.', 'et_builder'),
                ),
                'show_date' => array(
                    'label' => __('Show Date', 'et_builder'),
                    'type' => 'yes_no_button',
                    'option_category' => 'configuration',
                    'options' => array(
                        'off' => __('No', 'et_builder'),
                        'on' => __('Yes', 'et_builder'),
                    ),
                    'description' => __('Turn the date display on or off.', 'et_builder'),
                ),
                'show_excerpt' => array(
                    'label' => __('Show Excerpt', 'et_builder'),
                    'type' => 'yes_no_button',
                    'option_category' => 'configuration',
                    'options' => array(
                        'off' => __('No', 'et_builder'),
                        'on' => __('Yes', 'et_builder'),
                    ),
                    'affects' => array(
                        '#et_pb_excerpt_limit',
                    ),
                    'description' => __('Turn the excerpt display on or off', 'et_builder'),
                ),
                'excerpt_limit' => array(
                    'label' => __('Excerpt Limit', 'et_builder'),
                    'type' => 'text',
                    'description' => __('Enter number of characters to limit excerpt.', 'et_builder'),
                ),
                'show_more' => array(
                    'label' => __('Read More Button', 'et_builder'),
                    'type' => 'yes_no_button',
                    'option_category' => 'configuration',
                    'options' => array(
                        'off' => __('Off', 'et_builder'),
                        'on' => __('On', 'et_builder'),
                    ),
                    'description' => __('Here you can define whether to show "read more" link after the excerpts or not.', 'et_builder'),
                ),
                'show_pagination' => array(
                    'label' => __('Show Pagination', 'et_builder'),
                    'type' => 'yes_no_button',
                    'option_category' => 'configuration',
                    'options' => array(
                        'on' => __('Yes', 'et_builder'),
                        'off' => __('No', 'et_builder'),
                    ),
                    'description' => __('Enable or disable pagination for this feed.', 'et_builder'),
                ),
                'background_layout' => array(
                    'label' => __('Text Color', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'color_option',
                    'options' => array(
                        'light' => __('Dark', 'et_builder'),
                        'dark' => __('Light', 'et_builder'),
                    ),
                    'description' => __('Here you can choose whether your text should be light or dark. If you are working with a dark background, then your text should be light. If your background is light, then your text should be set to dark.', 'et_builder'),
                ),
                'disabled_on' => array(
                    'label' => esc_html__('Disable on', 'et_builder'),
                    'type' => 'multiple_checkboxes',
                    'options' => array(
                        'phone' => esc_html__('Phone', 'et_builder'),
                        'tablet' => esc_html__('Tablet', 'et_builder'),
                        'desktop' => esc_html__('Desktop', 'et_builder'),
                    ),
                    'additional_att' => 'disable_on',
                    'option_category' => 'configuration',
                    'description' => esc_html__('This will disable the module on selected devices', 'et_builder'),
                ),
                'admin_label' => array(
                    'label' => __('Admin Label', 'et_builder'),
                    'type' => 'text',
                    'description' => __('This will change the label of the module in the builder for easy identification.', 'et_builder'),
                ),
                'module_id' => array(
                    'label' => __('CSS ID', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'description' => __('Enter an optional CSS ID to be used for this module. An ID can be used to create custom CSS styling, or to create links to particular sections of your page.', 'et_builder'),
                ),
                'module_class' => array(
                    'label' => __('CSS Class', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'description' => __('Enter optional CSS classes to be used for this module. A CSS class can be used to create custom CSS styling. You can add multiple classes, separated with a space.', 'et_builder'),
                ),
                'hover_overlay_color' => array(
                    'label' => __('Hover Overlay Color', 'et_builder'),
                    'type' => 'color-alpha',
                    'custom_color' => true,
                ),
                'hover_icon' => array(
                    'label' => __('Hover Icon Picker', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'class' => array('et-pb-font-icon'),
                    'renderer' => 'et_pb_get_font_icon_list',
                    'renderer_with_field' => true,
                ),
                'zoom_icon_color' => array(
                    'label' => __('Zoom Icon Color', 'et_builder'),
                    'type' => 'color',
                    'custom_color' => true,
                ),
            );
            return $fields;
        }

        function dp_ocp_get_taxonomies() {
            foreach ($this->terms_array as $value) {
                $tax_name[] = $value['tax'];
            }
            return array_combine($tax_name, $tax_name);
        }

        function dp_ocp_get_taxonomy_of_post_type($pt) {
            $taxonomy = "";
            foreach ($this->terms_array as $value) {
                if ($pt === $value['pt']) {
                    $taxonomy = $value['tax'];
                    break;
                }
            }
            return $taxonomy;
        }

        function shortcode_callback($atts, $content = null, $function_name) {            
            global $offset_number;
            global $posts_number;
            wp_enqueue_script('easypiechart');
            $module_id = $this->shortcode_atts['module_id'];
            $module_class = $this->shortcode_atts['module_class'];
            $fullwidth = $this->shortcode_atts['fullwidth'];
            $posts_number = $this->shortcode_atts['posts_number'];
            $offset_number = $this->shortcode_atts['offset_number'];
            $orderby = $this->shortcode_atts['orderby'];
            $order = $this->shortcode_atts['order'];
            $custom_query = $this->shortcode_atts['custom_query'];
            $custom_post_types = $this->shortcode_atts['custom_post_types'];
            $include_categories = $this->shortcode_atts['include_categories'];
            $include_tags = $this->shortcode_atts['include_tags'];
            $exclude_tags = $this->shortcode_atts['exclude_tags'];
            $show_title = $this->shortcode_atts['show_title'];
            $lightbox = $this->shortcode_atts['lightbox'];
            $showPostPopup = $this->shortcode_atts['popup'];
            $custom_url = $this->shortcode_atts['custom_url'];
            $custom_url_field_name = $this->shortcode_atts['custom_url_field_name'];
            $url_new_window = $this->shortcode_atts['url_new_window'];
            $custom_fields = $this->shortcode_atts['custom_fields'];
            $custom_field_names = $this->shortcode_atts['custom_field_names'];
            $custom_field_labels = $this->shortcode_atts['custom_field_labels'];
            $show_categories = $this->shortcode_atts['show_categories'];
            $show_date = $this->shortcode_atts['show_date'];
            $show_excerpt = $this->shortcode_atts['show_excerpt'];
            $excerpt_limit = $this->shortcode_atts['excerpt_limit'];
            $show_more = $this->shortcode_atts['show_more'];
            $show_pagination = $this->shortcode_atts['show_pagination'];
            $background_layout = $this->shortcode_atts['background_layout'];
            $zoom_icon_color = $this->shortcode_atts['zoom_icon_color'];
            $hover_overlay_color = $this->shortcode_atts['hover_overlay_color'];
            $hover_icon = $this->shortcode_atts['hover_icon'];

            $post_types = array();

            if (!empty($custom_post_types)) {
                foreach (explode(',', $custom_post_types) as $value) {
                    $post_types[] = $value;
                }
            }

            $post_categories = array();

            if (!empty($include_categories)) {
                foreach (explode(',', $include_categories) as $value) {
                    $post_categories[] = $value;
                }
            }

            if ('on' == $custom_query) {
                $args = dp_ppp_custom_query();
            } else {
                $args = array('posts_per_page' => $posts_number, 'post_status' => 'publish');
                if (!empty($offset_number)) {
                    $args['offset'] = intval($offset_number);
                }
                if (!empty($post_types)) {
                    $args['post_type'] = $post_types;
                }
                $tax_query = array();
                if (!empty($post_categories)) {
                    foreach ($this->dp_ocp_get_taxonomies() as $tax) {
                        $tax_query[] = array(
                            'taxonomy' => $tax,
                            'field' => 'term_id',
                            'terms' => $post_categories,
                        );
                    }
                    if (count($tax_query >= 2)) {
                        $tax_query['relation'] = 'OR';
                    }
                }

                $args['orderby'] = $orderby;
                $args['order'] = $order;

                $tag_query = array();
                if (!empty($include_tags)) {
                    $tag_query[] = array(
                        'taxonomy' => 'post_tag',
                        'field' => 'slug',
                        'terms' => explode(',', $include_tags),
                        'operator' => 'IN'
                    );
                }
                if (!empty($exclude_tags)) {
                    $tag_query[] = array(
                        'taxonomy' => 'post_tag',
                        'field' => 'slug',
                        'terms' => explode(',', $exclude_tags),
                        'operator' => 'NOT IN'
                    );
                }
                if (count($tag_query) >= 2) {
                    $tag_query['relation'] = 'AND';
                }

                if (!empty($tax_query) && empty($tag_query)) {
                    $args['tax_query'] = $tax_query;
                } else if (empty($tax_query) && !empty($tag_query)) {
                    $args['tax_query'] = $tag_query;
                } else if (!empty($tax_query) && !empty($tag_query)) {
                    $args['tax_query'][] = $tax_query;
                    $args['tax_query'][] = $tag_query;
                    $args['tax_query']['relation'] = 'AND';
                }

                global $paged;

                 if ($show_pagination === 'on') {
                    if (get_query_var('paged')) {
                        $paged = get_query_var('paged');
                    } elseif (get_query_var('page')) {
                        $paged = get_query_var('page');
                    } else {
                        $paged = 1;
                    }
                    $args['paged'] = $paged;

                    if (!empty($offset_number)) {

                        add_action('pre_get_posts', 'dp_ppp_query_offset', 1);

                        if (!function_exists('dp_ppp_query_offset')) {

                            function dp_ppp_query_offset(&$query) {
                                global $offset_number;
                                global $posts_number;
                                global $paged;
                                if ($query->is_paged) {
                                    $page_offset = $offset_number + ( ($paged - 1) * $posts_number );
                                    $query->set('offset', $page_offset);
                                } else {
                                    $query->set('offset', $offset_number);
                                }
                            }

                        }

                        add_filter('found_posts', 'dp_ppp_adjust_offset_pagination', 1);

                        if (!function_exists('dp_ppp_adjust_offset_pagination')) {

                            function dp_ppp_adjust_offset_pagination($found_posts) {
                                global $offset_number;
                                return $found_posts - $offset_number;
                            }

                        }
                    }
                }
            }

            $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);

            if ('' !== $zoom_icon_color) {
                ET_Builder_Element::set_style($function_name, array(
                    'selector' => '%%order_class%% .et_overlay:before',
                    'declaration' => sprintf('color: %1$s !important;', esc_html($zoom_icon_color)),
                ));
            }

            if ('' !== $hover_overlay_color) {
                ET_Builder_Element::set_style($function_name, array(
                    'selector' => '%%order_class%% .et_overlay',
                    'declaration' => sprintf('background-color: %1$s; border-color: %1$s;', esc_html($hover_overlay_color)),
                ));
            }

            $container_is_closed = false;

            if ($fullwidth === 'on') {
                $main_class = '';
            } elseif ($fullwidth === 'off') {
                $main_class = ' et_pb_grid_item';
            } else {
                $main_class = ' dp_portfolio_list_item';
            }

            $main_post_class = sprintf('et_pb_portfolio_item%1$s', $main_class);

            ob_start();

            query_posts($args);

            if (have_posts()) {
                while (have_posts()) {
                    the_post();
                    ?>

                    <div id="post-<?php the_ID(); ?>" <?php post_class($main_post_class); ?>>

                        <?php
                        $thumb = '';
                        $post_custom_fields = '';
                        $post_id = get_the_ID();
                        $width = 'on' === $fullwidth ? 1080 : 400;
                        $width = (int) apply_filters('et_pb_portfolio_image_width', $width);
                        $lightbox_width = 1080;
                        $lightbox_width = (int) apply_filters('et_pb_portfolio_image_width', $lightbox_width);
                        $height = 'on' === $fullwidth ? 9999 : 400;
                        $height = (int) apply_filters('et_pb_portfolio_image_height', $height);
                        $lightbox_height = 9999;
                        $lightbox_height = (int) apply_filters('et_pb_portfolio_image_height', $lightbox_height);
                        $classtext = 'on' === $fullwidth ? 'et_pb_post_main_image' : '';
                        $titletext = get_the_title();
                        $thumbnail = get_thumbnail($width, $height, $classtext, $titletext, $titletext, false, 'Blogimage');
                        $thumb = $thumbnail["thumb"];
                        list($thumb_src, $thumb_width, $thumb_height) = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), array($lightbox_width, $lightbox_height));
                        $post_url = '';
                        $post_open_tab = "";
                        if (($custom_url == 'on') && ($custom_url_field_name != '')) {
                            $post_url = get_post_meta(get_the_ID(), $custom_url_field_name, true);
                            if ($post_url == '') {
                                $post_url = get_the_permalink();
                            }
                        } else {
                            $post_url = get_the_permalink();
                        }
                        if ($url_new_window === 'on' && $custom_url == 'on') {
                            $post_open_tab = '_blank';
                        }
                        $ajax_url = '';
                        if ($showPostPopup === 'on') {
                            $ajax_url = esc_url(add_query_arg('dp_action', 'popup_fetch', $post_url));
                        }

                        // Get all custom field names and display as names
                        if (($custom_fields == 'on') && ($custom_field_names != '')) {
                            $custom_fields_array = explode(",", $custom_field_names);
                            if ($custom_field_labels != '') {
                                $custom_fields_display = explode(",", $custom_field_labels);
                                if (is_array($custom_fields_array) && is_array($custom_fields_display) && count($custom_fields_array) == count($custom_fields_display)) {
                                    $custom_fields_array = array_combine($custom_fields_display, $custom_fields_array);
                                    $post_custom_fields = dp_get_keyed_custom_fields($custom_fields_array, $post_id);
                                } else {
                                    $post_custom_fields = dp_get_custom_fields($custom_fields_array, $post_id);
                                }
                            } else {
                                $post_custom_fields = dp_get_custom_fields($custom_fields_array, $post_id);
                            }
                        }

                        $carousel = 'off';
                        if ($lightbox == "on") {
                            $showPostPopup = "off";
                        }

                        if ($fullwidth === 'list') {
                            ?>
                            <div class="dp_portfolio_item_left">
                                <?php
                            }
                            if ('' !== $thumb) :
                                ?>
                                <?php if ($lightbox == 'on') { ?>
                                    <a href="<?php print $thumb_src; ?>" class="et_pb_lightbox_image">
                                    <?php } else if ($showPostPopup == 'on') { ?>
                                        <a href="" class="et_pb_lightbox_post_popup" data-rel="<?php echo get_the_ID(); ?>" data-showtitle="<?php echo $show_title; ?>" data-showdate="<?php echo $show_date; ?>" data-ajaxurl="<?php echo esc_url(add_query_arg('dp_action', 'popup_fetch', $post_url)); ?>">
                                        <?php } else { ?>
                                            <a href="<?php echo $post_url; ?>" target="<?php echo $post_open_tab; ?>">
                                            <?php } ?>
                                            <?php if ('on' !== $fullwidth) : ?>
                                                <span class="et_portfolio_image">
                                                <?php endif; ?>
                                                <?php print_thumbnail($thumb, $thumbnail["use_timthumb"], $titletext, $width, $height); ?>
                                                <?php
                                                if ('on' !== $fullwidth) :

                                                    $data_icon = '' !== $hover_icon ? sprintf(
                                                                    ' data-icon="%1$s"', esc_attr(et_pb_process_font_icon($hover_icon))
                                                            ) : '';

                                                    printf('<span class="et_overlay%1$s"%2$s></span>', ( '' !== $hover_icon ? ' et_pb_inline_icon' : ''), $data_icon
                                                    );
                                                    ?>
                                                </span>
                                            <?php endif; ?>
                                        </a>
                                        <?php if ($fullwidth === 'list') { ?>
                                            </div>
                                            <div class="dp_portfolio_item_right">
                                            <?php } ?>

                                            <?php
                                        endif;
                                        ?>

                                        <?php if ('on' === $show_title) : ?>
                                            <?php if ('on' === $lightbox || 'on' === $showPostPopup) { ?>
                                                <h2><?php the_title(); ?></h2>
                                            <?php } else { ?>
                                                <h2><a href="<?php echo $post_url; ?>"><?php the_title(); ?></a></h2>
                                            <?php } ?>
                                        <?php endif; ?>

                                        <?php if ('on' === $show_categories) : ?>
                                            <p class="post-meta">
                                                <?php echo get_the_term_list(get_the_ID(), $this->dp_ocp_get_taxonomy_of_post_type(get_post_type()), "", ", "); ?>
                                            </p>
                                        <?php endif; ?>

                                        <?php if ('on' === $show_date) : ?>
                                            <p class="post-meta"><?php echo get_the_date(); ?></p>
                                        <?php endif; ?>

                                        <?php if ($post_custom_fields) { ?>
                                            <?php foreach ($post_custom_fields as $field_display => $field_value) { ?>
                                                <?php if ($field_value != ''): ?>
                                                    <p class="post-meta dp-custom-field">
                                                        <span class="dp-custom-field-name"><?php echo $field_display; ?></span><span class="dp-custom-field-value"><?php echo $field_value; ?></span>
                                                    </p>
                                                <?php endif; ?>
                                            <?php }
                                            ?>
                                        <?php } ?>

                                        <?php if ('on' === $show_excerpt) { ?>
                                            <p class="post-excerpt"><?php dp_the_excerpt_max_charlength($excerpt_limit, $lightbox, $ajax_url, $show_more, $custom_url, $post_url, $carousel); ?></p>
                                            <?php
                                        } elseif (( ($show_more == 'on') && ($showPostPopup == 'on') && ($lightbox == 'off') && ($carousel == 'off'))) {
                                            $more_link = sprintf(' <a href="" class="more-link et_pb_lightbox_post_popup" data-ajaxurl="%1$s">%2$s</a>', $ajax_url, __('read more', 'et_builder'));
                                            echo $more_link;
                                        } elseif (( ($show_more == 'on') && ($lightbox == 'off') && ($carousel == 'off')) || (($show_more == 'on') && ($custom_url == 'on') && ($carousel == 'off'))) {
                                            $more_link = sprintf(' <a href="%1$s" class="more-link" >%2$s</a>', $post_url, __('read more', 'et_builder'));
                                            echo $more_link;
                                        }
                                        ?>
                                        <?php if ($fullwidth === 'list') { ?>
                                        </div>
                                    <?php } ?>
                                    </div> <!-- .et_pb_portfolio_item -->
                                    <?php
                                }

                                if ('on' === $show_pagination && !is_search()) {
                                    echo '</div> <!-- .et_pb_portfolio -->';

                                    $container_is_closed = true;

                                    if (function_exists('wp_pagenavi')) {
                                        wp_pagenavi();
                                    } else {
                                        if (et_is_builder_plugin_active()) {
                                            include( ET_BUILDER_PLUGIN_DIR . 'includes/navigation.php' );
                                        } else {
                                            get_template_part('includes/navigation', 'index');
                                        }
                                    }
                                }

                                wp_reset_query();
                            } else {
                                if (et_is_builder_plugin_active()) {
                                    include( ET_BUILDER_PLUGIN_DIR . 'includes/no-results.php' );
                                } else {
                                    get_template_part('includes/no-results', 'index');
                                }
                            }

                            $posts = ob_get_contents();

                            ob_end_clean();

                            $class = " et_pb_module et_pb_bg_layout_{$background_layout}";

                            if ($fullwidth === 'on') {
                                $layout_class = 'et_pb_portfolio';
                            } elseif ($fullwidth === 'off') {
                                $layout_class = 'et_pb_portfolio_grid clearfix';
                            } else {
                                $layout_class = 'et_pb_portfolio_list';
                            }

                            $spinner = plugin_dir_url(__FILE__) . 'popup_loading.gif';
                            $popup_container = '<!-- Start Popup html -->
					<div class="modal_overlay">&nbsp;</div>
					<div class="modal">
						<div class="et_pb_loader_img">
							<img src="' . $spinner . '" alt="loader"/>
						</div>
						<button class="pop_up_close_btn" type="button" title="Close (Esc)">x</button>
						<div id="modal_inner" class="modal_inner">
							<div class="modal_header"></div>
							<iframe id="dp_iframe" class="dp_iframe"></iframe>
							<div class="modal_footer"></div>
						</div>
					</div>
					<!-- Ends Popup html -->';

                            $output = sprintf(
                                    '<div%5$s class="%1$s%3$s%6$s">
				%2$s
			%4$s
			%7$s', $layout_class, $posts, esc_attr($class), (!$container_is_closed ? '</div> <!-- .et_pb_portfolio -->' : ''), ( '' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''), ( '' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''), ( 'on' === $showPostPopup ? $popup_container : '')
                            );

                            return $output;
                        }

                    }

                    new ET_Builder_Module_DP_Blog_Portfolio;
                }//IF Divi Theme activated
                ?>