<?php
/**
 * Plugin Name: DP Portfolio Posts Pro
 * Plugin URI: http://www.diviplugins.com/divi/portfolio-posts-pro-plugin/
 * Description: Creates three new modules similar to Divi's portfolio modules, but with the ability to load posts or any custom post type. Also adds new features: open posts in a popup window, open the featured image in a lightbox, display custom fields.
 * Version: 3.1
 * Author: DiviPlugins
 * Author URI: http://www.diviplugins.com
 * */
// Adding a test comment
// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

define('DPPPP_PLUGIN_NAME', 'dp_ppp');
define('DPPPP_PLUGIN_VERSION', '3.1');
define('DPPPP_PLUGIN_DIR', WP_PLUGIN_DIR . '/' . basename(dirname(__FILE__)));
define('DPPPP_STORE_URL', 'https://diviplugins.com/');
define('DPPPP_ITEM_NAME', 'Portfolio Posts Pro');
define('DPPPP_ITEM_ID', '4548');
define('DPPPP_PLUGIN_LICENSE_PAGE', 'dp_ppp_license');

if (!class_exists('DP_PPP_Plugin_Updater')) {
    require_once DPPPP_PLUGIN_DIR . '/dp-ppp-plugin-updater.php';
}

if (get_transient('dp_ppp_check_license_status') && get_option('dp_ppp_license_status') === 'valid') {
    //TODO to remove some functionality
} else {
    dp_ppp_check_license();
}

register_activation_hook(__FILE__, 'dp_ppp_install');

if (!function_exists('dp_ppp_install')) {

    function dp_ppp_install() {
        dp_ppp_create_table();
    }

}

register_deactivation_hook(__FILE__, 'dp_ppp_uninstall');

if (!function_exists('dp_ppp_uninstall')) {

    function dp_ppp_uninstall() {
        dp_ppp_remove_table();
    }

}

function dp_module_loading_amount() {
    $amount = 70;
    return $amount;
}

add_filter('et_pb_templates_loading_amount', 'dp_module_loading_amount');

add_action('et_builder_ready', 'dp_ppp_get_the_modules');

function dp_ppp_get_the_modules() {
    if (dp_oc_get_divi_version() >= 3045) {
        require 'includes/dp_blog_portfolio.php';
        require 'includes/dp_filterable_blog.php';
        require 'includes/dp_fullwidth_blog.php';
    } else {
        require 'includes/dp_blog_portfolio_45.php';
        require 'includes/dp_filterable_blog_45.php';
        require 'includes/dp_fullwidth_blog_45.php';
    }
}

include 'includes/global_settings.php';

// REGISTER ADMIN STYLES AND SCRIPTS
function register_dp_plugin_admin_styles() {
    wp_register_style('dp-ppp-admin-css', plugin_dir_url(__FILE__) . 'admin/css/style.css', false, '1.0.1');
    wp_enqueue_style('dp-ppp-admin-css');
    wp_enqueue_script('dp-ppp-admin-js', plugin_dir_url(__FILE__) . 'admin/js/functions.js', array('jquery'), '1.0.1');
}

add_action('admin_enqueue_scripts', 'register_dp_plugin_admin_styles');

function dp_delete_popup_page() {

    $is_dp_popup = get_page_by_path('dp-popup');
    if (!empty($is_dp_popup)) {
        $page_id = $is_dp_popup->ID;
        wp_delete_post($page_id, true);
    }
}

// Popup page no longer needed. When the plugin is activated, run the popup page delete function
register_activation_hook(__FILE__, 'dp_delete_popup_page');

// When the plugin is deactivated, run the popup page delete function
register_deactivation_hook(__FILE__, 'dp_delete_popup_page');

// IF PAGE IS OPENED FROM POPUP AJAX FUNCTION, LOAD THE POPUP CONTENT TEMPLATE

add_filter('single_template', 'dp_popup_page_template');

function dp_popup_page_template($template) {

    if (is_single() || is_product()) {

        if (isset($_GET['dp_action']) && $_GET['dp_action'] == 'popup_fetch') {
            $template = dirname(__FILE__) . '/templates/dp-popup-template.php';

            // ADD NOINDEX META TAG TO POPUP PAGE
            add_action('wp_head', 'dp_noindex_popup');

            function dp_noindex_popup() {
                wp_no_robots();
            }

        } else {
            return $template;
        }
    }

    return $template;
}

// REGISTER STYLES AND SCRIPTS
function register_dp_plugin_module_styles() {
    wp_register_style('dp-ppp-css', plugin_dir_url(__FILE__) . 'css/style.css', false, '1.0.3');
    wp_enqueue_style('dp-ppp-css');
    wp_enqueue_script('dp-ppp-ajax-js', plugin_dir_url(__FILE__) . 'js/ajax-get-post.js', array('jquery'), '1.0.4');
}

add_action('wp_enqueue_scripts', 'register_dp_plugin_module_styles');

/*
 *
 * ################## HELPER FUNCTIONS ################## *
 *
 */

/*
 * CUSTOM DB FUNCTIONS
 */
if (!function_exists('dp_ppp_create_table')) {

    function dp_ppp_create_table() {
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();
        $table_name = $wpdb->prefix . "dp_available_categories";
        if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
            $sql = "CREATE TABLE $table_name (
                    id bigint(20) auto_increment NOT NULL,
                    term_id mediumint(9) NOT NULL,
                    name tinytext NOT NULL,
                    pt tinytext NOT NULL,
                    tax tinytext NOT NULL,
                    PRIMARY KEY  (id)
	) $charset_collate;";
            if (!function_exists('dbDelta')) {
                require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
            }
            dbDelta($sql);
            dp_ppp_fill_table();
        }
    }

}

if (!function_exists('dp_ppp_remove_table')) {

    function dp_ppp_remove_table() {
        global $wpdb;
        $table_name = $wpdb->prefix . "dp_available_categories";
        $sql = "DROP TABLE IF EXISTS $table_name;";
        $wpdb->query($sql);
    }

}

if (!function_exists('dp_ppp_get_post_types_and_taxonomies')) {

    function dp_ppp_get_post_types_and_taxonomies() {
        $default_post_type = array('post' => 'post',);
        $post_types = get_post_types(array('_builtin' => false, 'public' => true));
        $post_types += $default_post_type;
        foreach ($post_types as $pt) {
            $pt_taxs = get_object_taxonomies($pt);
            if (empty($pt_taxs)) {
                $cats_array[] = array('cat_id' => 'dp_none_taxonomy', 'cat_name' => 'dp_none_taxonomy', 'pt' => $pt, 'tax' => 'dp_none_taxonomy');
            } else {
                foreach ($pt_taxs as $pt_tax) {
                    if ($pt_tax != 'post_tag' && $pt_tax != 'post_format' && get_taxonomy($pt_tax)->show_ui) {
                        $terms = get_terms(array('taxonomy' => $pt_tax, 'hide_empty' => false));
                        foreach ($terms as $term) {
                            $cats_array[] = array('cat_id' => $term->term_id, 'cat_name' => $term->name, 'pt' => $pt, 'tax' => $pt_tax);
                        }
                    }
                }
            }
        }
        return $cats_array;
    }

}

if (!function_exists('dp_ppp_fill_table')) {

    function dp_ppp_fill_table() {
        $cat_arrays = dp_ppp_get_post_types_and_taxonomies();
        if (!empty($cat_arrays)) {
            global $wpdb;
            $table_name = $wpdb->prefix . "dp_available_categories";
            $wpdb->query("TRUNCATE $table_name;");
            foreach ($cat_arrays as $cat) {
                $wpdb->insert(
                        $table_name, array(
                    'term_id' => $cat['cat_id'],
                    'name' => $cat['cat_name'],
                    'pt' => $cat['pt'],
                    'tax' => $cat['tax'],
                        )
                );
            }
        }
    }

}

if (!function_exists('dp_ppp_terms_array')) {

    function dp_ppp_terms_array() {
        global $wpdb;
        $table_name = $wpdb->prefix . "dp_available_categories";
        if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
            dp_ppp_create_table();
        }
        return $wpdb->get_results("SELECT term_id,name,pt,tax FROM $table_name WHERE tax!='dp_none_taxonomy'; ", ARRAY_A);
    }

}

if (!function_exists('dp_ppp_get_post_types')) {

    function dp_ppp_get_post_types() {
        global $wpdb;
        $table_name = $wpdb->prefix . "dp_available_categories";
        if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
            dp_ppp_create_table();
        }
        return $wpdb->get_results("SELECT DISTINCT pt FROM $table_name;", ARRAY_A);
    }

}

if (!function_exists('dp_ppp_get_terms')) {

    function dp_ppp_get_terms() {
        global $wpdb;
        $table_name = $wpdb->prefix . "dp_available_categories";
        if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
            dp_ppp_create_table();
        }
        return $wpdb->get_results("SELECT DISTINCT term_id,name,pt FROM $table_name;", ARRAY_A);
    }

}

if (!function_exists('dp_ppp_add_term')) {

    function dp_ppp_add_term($term_id, $tt_id, $taxonomy) {
        $tax = get_taxonomy($taxonomy);
        $term = get_term_field('name', $term_id, $taxonomy);
        $default_post_type = array('post' => 'post',);
        $post_types = get_post_types(array('_builtin' => false, 'public' => true));
        $post_types += $default_post_type;
        if (in_array($tax->object_type[0], $post_types) && $tax->name !== 'post_tag') {
            global $wpdb;
            $table_name = $wpdb->prefix . "dp_available_categories";
            if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
                dp_ppp_create_table();
            }
            $wpdb->insert($table_name, array('term_id' => $term_id, 'name' => $term, 'tax' => $taxonomy, 'pt' => $tax->object_type[0]), array('%d', '%s', '%s', '%s'));
        }
    }

}

add_action('created_term', 'dp_ppp_add_term', 10, 3);

if (!function_exists('dp_ppp_delete_term')) {

    function dp_ppp_delete_term($term_id) {
        global $wpdb;
        $table_name = $wpdb->prefix . "dp_available_categories";
        if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
            dp_ppp_create_table();
        }
        $wpdb->delete($table_name, array('term_id' => $term_id), array('%d'));
    }

}

add_action('delete_term', 'dp_ppp_delete_term', 10, 1);

if (!function_exists('dp_ppp_edit_term')) {

    function dp_ppp_edit_term($term_id, $taxonomy) {
        $tax = get_taxonomy($taxonomy);
        $term = get_term_field('name', $term_id, $taxonomy);
        global $wpdb;
        $table_name = $wpdb->prefix . "dp_available_categories";
        if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
            dp_ppp_create_table();
        }
        $wpdb->update($table_name, array('term_id' => $term_id, 'name' => $term, 'tax' => $taxonomy, 'pt' => $tax->object_type[0]), array('term_id' => $term_id), array('%d', '%s', '%s', '%s'), array('%d'));
    }

}

add_action('edited_terms', 'dp_ppp_edit_term', 10, 2);

if (!function_exists('dp_ppp_add_cpt')) {

    function dp_ppp_add_cpt($post_type, $post_type_object) {//here we get the post type slug and the post type object          
        if (!$post_type_object->_builtin && $post_type_object->public && $post_type != 'project') { //if the post type is not _builtin and is public and is not project because cpt project is already in the db when the plugin is install 
            global $wpdb;
            $table_name = $wpdb->prefix . "dp_available_categories";
            if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
                dp_ppp_create_table();
            }
            $already_in = $wpdb->get_results("SELECT DISTINCT term_id,name,pt FROM $table_name WHERE pt='" . $post_type . "';", ARRAY_A);
            if (empty($already_in)) {
                $wpdb->insert($table_name, array('term_id' => 0, 'name' => 'dp_none_taxonomy', 'tax' => 'dp_none_taxonomy', 'pt' => $post_type), array('%d', '%s', '%s', '%s'));
            }
        }
    }

}

add_action('registered_post_type', 'dp_ppp_add_cpt', 10, 2); //When a post is registered run dp_ppp_add_cpt 
// Get a list of all available custom post types and output them in html inputs
if (!function_exists('dp_ppp_custom_post_types_option')) :

    function dp_ppp_custom_post_types_option() {
        $post_types = dp_ppp_get_post_types();
        $output = "\t" . "<% var et_pb_custom_post_types_temp = typeof et_pb_custom_post_types !== 'undefined' ? et_pb_custom_post_types.split( ',' ) : []; %>" . "\n";
        foreach ($post_types as $post_type) {
            $contains = sprintf('<%%= _.contains( et_pb_custom_post_types_temp, "%1$s" ) ? checked="checked" : "" %%>', esc_html($post_type['pt']));
            $output .= sprintf('%4$s<label><input type="checkbox" class="et_dp_ppp_cpt" name="et_pb_custom_post_types" value="%1$s"%3$s> %2$s</label><br/>', esc_attr($post_type['pt']), esc_html(ucfirst($post_type['pt'])), $contains, "\n\t\t\t\t\t");
        }
        return apply_filters('dp_custom_post_types_option_html', $output);
    }

endif;

// Get a list of all available categories from each custom post type and output them
if (!function_exists('dp_ppp_categories_option')) :

    function dp_ppp_categories_option() {
        $output = "\t" . "<% var et_pb_include_categories_temp = typeof et_pb_include_categories !== 'undefined' ? et_pb_include_categories.split( ',' ) : []; %>" . "\n";
        $cats_array = dp_ppp_get_terms();
        if (empty($cats_array)) {
            $output = '<p>' . esc_html__("You currently don't have any projects assigned to a category.", 'et_builder') . '</p>';
        } else {
            foreach ($cats_array as $category) {
                if ($category['name'] != 'dp_none_taxonomy') {
                    $contains = sprintf('<%%= _.contains( et_pb_include_categories_temp, "%1$s" ) ? checked="checked" : "" %%>', esc_html($category['term_id']));
                    $output .= sprintf('%4$s<label class="et_dp_ppp_categories"><input type="checkbox"  name="et_pb_include_categories" value="%1$s"%3$s> %2$s</label><br/>', esc_attr($category['term_id']), esc_html($category['name'] . " (" . $category['pt'] . ")"), $contains, "\n\t\t\t\t\t");
                }
            }
        }
        return apply_filters('dp_categories_option_html', $output);
    }

endif;

// Custom Query Arguments Filter
if (!function_exists('dp_ppp_custom_query')) :

    function dp_ppp_custom_query() {
        $args = apply_filters('dp_ppp_custom_query_args', array('posts_per_page' => 10, 'post_type' => 'post', 'post_status' => 'publish'));
        return $args;
    }

endif;

// Create an excerpt based on module settings
if (!function_exists('dp_the_excerpt_max_charlength')) :

    function dp_the_excerpt_max_charlength($excerpt_limit, $lightbox, $ajax_url, $show_more, $custom_url, $post_url, $carousel) {

        $excerpt = get_the_excerpt();
        if (!empty($ajax_url)) {
            $more_link = sprintf(' <a href="" class="more-link et_pb_lightbox_post_popup" data-ajaxurl="%1$s" ><i class="arrow_carrot-right_alt2"></i>%2$s</a>', $ajax_url, __('Lire la suite', 'et_builder'));
        } else {
            $more_link = sprintf(' <a href="%1$s" class="more-link" ><i class="arrow_carrot-right_alt2"></i> %2$s</a>', $post_url, __('lire la suite', 'et_builder'));
        }

        if (empty($excerpt)) {
            $excerpt = dp_strip_shortcodes(get_the_content());
        }

        $charlength = $excerpt_limit;
        $charlength++;

        if (mb_strlen($excerpt) > $charlength) {
            $subex = mb_substr($excerpt, 0, $charlength - 5);
            $exwords = explode(' ', $subex);
            $excut = - ( mb_strlen($exwords[count($exwords) - 1]) );
            if ($excut < 0) {
                echo mb_substr($subex, 0, $excut) . '...';
            } else {
                echo $subex;
            }
            if (( ($show_more == 'on') && ($lightbox == 'off') && ($carousel == 'off')) || (($show_more == 'on') && ($custom_url == 'on') && ($carousel == 'off'))) {
                echo $more_link;
            }
        } else {
            echo $excerpt;
            if (( ($show_more == 'on') && ($lightbox == 'off') && ($carousel == 'off')) || (($show_more == 'on') && ($custom_url == 'on') && ($carousel == 'off'))) {
                echo $more_link;
            }
        }
    }

endif;

if (!function_exists('et_strip_shortcodes')) :

    function dp_strip_shortcodes($content) {
        $content = trim($content);

        $strip_content_shortcodes = array(
            'et_pb_code',
            'et_pb_fullwidth_code',
        );

        foreach ($strip_content_shortcodes as $shortcode_name) {
            $regex = sprintf(
                    '(\[%1$s[^\]]*\][^\[]*\[\/%1$s\])', esc_html($shortcode_name)
            );

            $content = preg_replace($regex, '', $content);
        }

        $content = preg_replace('(\[[^\]]+\])', '', $content);

        return $content;
    }

endif;

// Get custom fields function
if (!function_exists('dp_get_custom_fields')) :

    function dp_get_custom_fields($custom_fields_array, $post_id) {
        foreach ($custom_fields_array as $field_display) {
            $custom_field = trim($field_display);
            $field_display = ucfirst(str_replace('_', ' ', ltrim($field_display)));
            $field_display .= ' - ';
            $post_custom_fields[$field_display] = get_post_meta($post_id, $custom_field, true);
        }
        return $post_custom_fields;
    }

endif;

// Get custom fields function if custom labels are also set and correct
if (!function_exists('dp_get_keyed_custom_fields')) :

    function dp_get_keyed_custom_fields($custom_fields_array, $post_id) {
        foreach ($custom_fields_array as $field_display => $field_value) {
            $custom_field = trim($field_value);
            $post_custom_fields[$field_display] = get_post_meta($post_id, $custom_field, true);
        }
        return $post_custom_fields;
    }

endif;

if (!function_exists('dp_oc_get_divi_version')) {

    function dp_oc_get_divi_version() {
        $my_theme = wp_get_theme('Divi');
        return str_replace('.', '', $my_theme->get('Version'));
    }

}

/*
 * Activation Functions
 */

function dp_ppp_plugin_updater() {

    // retrieve our license key from the DB
    $license_key = trim(get_option('dp_ppp_license_key'));

    // setup the updater
    $dp_ppp_updater = new DP_PPP_Plugin_Updater(DPPPP_STORE_URL, __FILE__, array(
        'version' => DPPPP_PLUGIN_VERSION, // current version number
        'license' => $license_key, // license key (used get_option above to retrieve from DB)
        //'item_id' => DPPPP_ITEM_ID, // id of this plugin
        'item_name' => DPPPP_ITEM_NAME, // name of this plugin
        'author' => 'Divi Plugins', // author of this plugin
        'beta' => false
            )
    );
}

add_action('admin_init', 'dp_ppp_plugin_updater', 0);


/* * **********************************
 * the code below is just a standard
 * options page. Substitute with
 * your own.
 * *********************************** */

function dp_ppp_license_menu() {
    add_plugins_page('Plugin License', 'PPP License', 'manage_options', DPPPP_PLUGIN_LICENSE_PAGE, 'dp_ppp_license_page');
}

add_action('admin_menu', 'dp_ppp_license_menu');

function dp_ppp_license_page() {
    $license = get_option('dp_ppp_license_key');
    $status = get_option('dp_ppp_license_status');
    ?>
    <div class="wrap">
        <h2><?php _e('Portfolio Post Pro License Options'); ?></h2>
        <form method="post" action="options.php">

            <?php settings_fields('dp_ppp_license'); ?>

            <table class="form-table">
                <tbody>
                    <tr valign="top">
                        <th scope="row" valign="top">
                            <?php _e('License Key', DPPPP_PLUGIN_NAME); ?>
                        </th>
                        <td>
                            <input id="dp_ppp_license_key" name="dp_ppp_license_key" type="text" class="regular-text" value="<?php esc_attr_e($license); ?>" />
                            <label class="description" for="dp_ppp_license_key"><?php _e('Enter your license key', DPPPP_PLUGIN_NAME); ?></label>
                        </td>
                    </tr>
                    <?php if (false !== $license) { ?>
                        <tr valign="top">
                            <th scope="row" valign="top">
                                <?php _e('Activate License', DPPPP_PLUGIN_NAME); ?>
                            </th>
                            <td>
                                <?php if ($status !== false && $status == 'valid') { ?>
                                    <span style="color:green; font-weight: bold; font-size: 18px; vertical-align: bottom;"><?php _e('Active', DPPPP_PLUGIN_NAME); ?></span>
                                    <?php wp_nonce_field('dp_ppp_license_nonce', 'dp_ppp_license_nonce'); ?>
                                    <input type="submit" class="button-secondary" name="dp_ppp_license_deactivate" value="<?php _e('Deactivate License', DPPPP_PLUGIN_NAME); ?>"/>
                                    <?php
                                } else {
                                    wp_nonce_field('dp_ppp_license_nonce', 'dp_ppp_license_nonce');
                                    ?>
                                    <input type="submit" class="button-secondary" name="dp_ppp_license_activate" value="<?php _e('Activate License', DPPPP_PLUGIN_NAME); ?>"/>
                                <?php } ?>
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
            <?php submit_button(); ?>

        </form>
    </div>
    <?php
}

function dp_ppp_register_option() {
    // creates our settings in the options table
    register_setting('dp_ppp_license', 'dp_ppp_license_key', 'dp_ppp_sanitize_license');
}

add_action('admin_init', 'dp_ppp_register_option');

function dp_ppp_sanitize_license($new) {
    $old = get_option('dp_ppp_license_key');
    if ($old && $old != $new) {
        delete_option('dp_ppp_license_status'); // new license has been entered, so must reactivate
    }
    return $new;
}

/* * **********************************
 * this illustrates how to activate
 * a license key
 * *********************************** */

function dp_ppp_activate_license() {

    // listen for our activate button to be clicked
    if (isset($_POST['dp_ppp_license_activate'])) {

        // run a quick security check
        if (!check_admin_referer('dp_ppp_license_nonce', 'dp_ppp_license_nonce')) {
            return; // get out if we didn't click the Activate button
        }

        // retrieve the license from the database
        $license = trim(get_option('dp_ppp_license_key'));

        // data to send in our API request
        $api_params = array(
            'edd_action' => 'activate_license',
            'license' => $license,
            'item_name' => urlencode(DPPPP_ITEM_NAME), // the name of our product in EDD
            'url' => home_url()
        );

        // Call the custom API.
        $response = wp_remote_post(DPPPP_STORE_URL, array('timeout' => 15, 'sslverify' => false, 'body' => $api_params));

        // make sure the response came back okay
        if (is_wp_error($response) || 200 !== wp_remote_retrieve_response_code($response)) {

            if (is_wp_error($response)) {
                $message = $response->get_error_message();
            } else {
                $message = __('An error occurred, please try again.');
            }
        } else {
            $license_data = json_decode(wp_remote_retrieve_body($response));
            if (false === $license_data->success) {
                switch ($license_data->error) {
                    case 'expired' :
                        $message = sprintf(
                                __('Your license key expired on %s.', DPPPP_PLUGIN_NAME), date_i18n(get_option('date_format'), strtotime($license_data->expires, current_time('timestamp')))
                        );
                        break;
                    case 'revoked' :
                        $message = __('Your license key has been disabled.', DPPPP_PLUGIN_NAME);
                        break;
                    case 'missing' :
                        $message = __('Invalid license.', DPPPP_PLUGIN_NAME);
                        break;
                    case 'invalid' :
                    case 'site_inactive' :
                        $message = __('Your license is not active for this URL.', DPPPP_PLUGIN_NAME);
                        break;
                    case 'item_name_mismatch' :
                        $message = sprintf(__('This appears to be an invalid license key for %s.', DPPPP_PLUGIN_NAME), DPPPP_ITEM_NAME);
                        break;
                    case 'no_activations_left':
                        $message = __('Your license key has reached its activation limit.', DPPPP_PLUGIN_NAME);
                        break;
                    default :
                        $message = __('An error occurred, please try again.', DPPPP_PLUGIN_NAME);
                        break;
                }
            }
        }

        // Check if anything passed on a message constituting a failure
        if (!empty($message)) {
            $base_url = admin_url('plugins.php?page=' . DPPPP_PLUGIN_LICENSE_PAGE);
            $redirect = add_query_arg(array('sl_activation' => 'false', 'message' => urlencode($message)), $base_url);

            wp_redirect($redirect);
            exit();
        }

        // $license_data->license will be either "valid" or "invalid"

        update_option('dp_ppp_license_status', $license_data->license);
        delete_transient('dp_ppp_license_status');
        wp_redirect(admin_url('plugins.php?page=' . DPPPP_PLUGIN_LICENSE_PAGE));
        exit();
    }
}

add_action('admin_init', 'dp_ppp_activate_license');


/* * *********************************************
 * Illustrates how to deactivate a license key.
 * This will decrease the site count
 * ********************************************* */

function dp_ppp_deactivate_license() {

    // listen for our activate button to be clicked
    if (isset($_POST['dp_ppp_license_deactivate'])) {

        // run a quick security check
        if (!check_admin_referer('dp_ppp_license_nonce', 'dp_ppp_license_nonce')) {
            return; // get out if we didn't click the Activate button
        }

        // retrieve the license from the database
        $license = trim(get_option('dp_ppp_license_key'));

        // data to send in our API request
        $api_params = array(
            'edd_action' => 'deactivate_license',
            'license' => $license,
            'item_name' => urlencode(DPPPP_ITEM_NAME), // the name of our product in EDD
            'url' => home_url()
        );

        // Call the custom API.
        $response = wp_remote_post(DPPPP_STORE_URL, array('timeout' => 15, 'sslverify' => false, 'body' => $api_params));

        // make sure the response came back okay
        if (is_wp_error($response) || 200 !== wp_remote_retrieve_response_code($response)) {

            if (is_wp_error($response)) {
                $message = $response->get_error_message();
            } else {
                $message = __('An error occurred, please try again.');
            }

            $base_url = admin_url('plugins.php?page=' . DPPPP_PLUGIN_LICENSE_PAGE);
            $redirect = add_query_arg(array('sl_activation' => 'false', 'message' => urlencode($message)), $base_url);

            wp_redirect($redirect);
            exit();
        }

        // decode the license data
        $license_data = json_decode(wp_remote_retrieve_body($response));

        // $license_data->license will be either "deactivated" or "failed"
        if ($license_data->license == 'deactivated') {
            delete_option('dp_ppp_license_status');
            delete_transient('dp_ppp_check_license_status');
        }

        wp_redirect(admin_url('plugins.php?page=' . DPPPP_PLUGIN_LICENSE_PAGE));
        exit();
    }
}

add_action('admin_init', 'dp_ppp_deactivate_license');


/* * **********************************
 * this illustrates how to check if
 * a license key is still valid
 * the updater does this for you,
 * so this is only needed if you
 * want to do something custom
 * *********************************** */

function dp_ppp_check_license() {

    global $wp_version;

    $license = trim(get_option('dp_ppp_license_key'));

    $api_params = array(
        'edd_action' => 'check_license',
        'license' => $license,
        'item_name' => urlencode(DPPPP_ITEM_NAME),
        'url' => home_url()
    );

    // Call the custom API.
    $response = wp_remote_post(DPPPP_STORE_URL, array('timeout' => 15, 'sslverify' => false, 'body' => $api_params));

    if (is_wp_error($response)) {
        add_action('admin_notices', 'dp_ppp_admin_notice_error_connection');
    } else {
        $license_data = json_decode(wp_remote_retrieve_body($response));
        if ($license_data->license == 'valid' && get_option('dp_ppp_license_status') === 'valid') {
            set_transient('dp_ppp_check_license_status', true, 604800);
        } else {
            set_transient('dp_ppp_check_license_status', false, 604800);
            add_action('admin_notices', 'dp_ppp_admin_notice_activation');
        }
    }
}

/**
 * This is a means of catching errors from the activation method above and displaying it to the customer
 */
function dp_ppp_admin_notices() {
    if (isset($_GET['sl_activation']) && !empty($_GET['message']) && $_GET['page'] === 'dp_ppp_license') {
        switch ($_GET['sl_activation']) {
            case 'false':
                $message = urldecode($_GET['message']);
                ?>
                <div class="notice notice-error is-dismissible">
                    <p><?php echo $message; ?></p>
                </div>
                <?php
                break;
            case 'true':
            default:
                // Developers can put a custom success message here for when activation is successful if they way.
                ?>
                <?php
                break;
        }
    }
}

add_action('admin_notices', 'dp_ppp_admin_notices');

function dp_ppp_admin_notice_activation() {
    ?>
    <div class="notice notice-info is-dismissible">
        <p><?php _e('Please activate your Portfolio Post Pro license.', DPPPP_PLUGIN_NAME); ?> <a href="plugins.php?page=<?php echo DPPPP_PLUGIN_LICENSE_PAGE; ?>"><?php _e('PPP Activation Page', DPPPP_PLUGIN_NAME); ?></a></p>
    </div>
    <?php
}

function dp_ppp_admin_notice_error_connection() {
    ?>
    <div class="notice notice-error is-dismissible">
        <p><?php _e('Portfolio Post Pro is trying to reach the activation server without success. Try again later.', DPPPP_PLUGIN_NAME); ?></p>
    </div>
    <?php
}
?>
