<?php

class et_pb_acf_single extends ET_Builder_Module
{
    function init()
    {
        $this->name = esc_html__('ACF Single Item', 'et_builder');
        $this->slug = 'et_pb_acf_single_item';

        $this->whitelisted_fields = array(
            'module_id',
            'module_class',
            'field_name',
            'image_size',
            'format_output',
            'date_format',
            'title',
            'link_image'
        );

        $this->options_toggles = array(
            'general' => array(
                'toggles' => array(
                    'main_settings' => esc_html__('Main Settings', 'et_builder'),
                ),
            ),
        );

        $this->fields_defaults = array();
        //$this->main_css_element = '.et_pb_acf_single';
        $this->main_css_element = '%%order_class%%';

        $this->advanced_options = array(
            'fonts' => array(
                'text' => array(
                    'label' => esc_html__('Text', 'et_builder'),
                    'css' => array(
                        'main' => "{$this->main_css_element} p",
                    ),
                    'font_size' => array('default' => '14px'),
                    'line_height' => array('default' => '1.5em'),
                ),
                'headings' => array(
                    'label' => esc_html__('Headings', 'et_builder'),
                    'css' => array(
                        'main' => "{$this->main_css_element} h1, {$this->main_css_element} h2, {$this->main_css_element} h1 a, {$this->main_css_element} h2 a, {$this->main_css_element} h3, {$this->main_css_element} h4",
                    ),
                    'font_size' => array('default' => '30px'),
                    'line_height' => array('default' => '1.5em'),
                ),
            ),
            'background' => array(
                'settings' => array(
                    'color' => 'alpha',
                ),
            ),
            'border' => array(),
            'custom_margin_padding' => array(
                'css' => array(
                    'important' => 'all',
                ),
            ),
        );

    }

    function get_fields()
    {
        $options = sb_mod_acf_get_fields();

        $image_link_options = array(
            'none'=>'No Link'
            , 'image'=>'Larger version'
            , 'page'=>'Same Page'
        );

        $image_options = array();
        $sizes = get_intermediate_image_sizes();

        foreach ($sizes as $size) {
            $image_options[$size] = $size;
        }

        $fields = array(
            'title' => array(
                'label' => esc_html__('Title', 'et_builder'),
                'type' => 'text',
                'description' => esc_html__('The label that will be used for this field on the front end. (Optional)', 'et_builder'),
                'toggle_slug' => 'main_settings',
            ),
            'field_name' => array(
                'label' => __('Field', 'et_builder'),
                'type' => 'select',
                'options' => $options,
                'description' => __('Pick which field to show.', 'et_builder'),
                'toggle_slug' => 'main_settings',
            ),
            'image_size' => array(
                'label' => __('Image Size', 'et_builder'),
                'type' => 'select',
                'options' => $image_options,
                'description' => __('If this is an image type then choose a size from here. If there is no size you like in the list consider using the free <a href="https://wordpress.org/plugins/simple-image-sizes/" target="_blank">Simple Image Sizes</a> plugin where you can define your own.', 'et_builder'),
                'toggle_slug' => 'main_settings',
            ),
            'link_image' => array(
                'label' => __('Image Link', 'et_builder'),
                'type' => 'select',
                'options' => $image_link_options,
                'description' => __('If this is an image type then please choose how it should be linked. This means that when the image is clicked, what should happen.', 'et_builder'),
                'toggle_slug' => 'main_settings',
            ),
            'date_format' => array(
                'label' => esc_html__('Date Format', 'et_builder'),
                'type' => 'text',
                'description' => esc_html__('If this is a date picker type, enter format here. (Optional)', 'et_builder'),
                'toggle_slug' => 'main_settings',
            ),
            'format_output' => array(
                'label' => __('Output Format', 'et_builder'),
                'type' => 'select',
                'options' => array('none' => 'None', 'autop' => 'Add Paragraphs', 'audio' => 'Show Audio Player', 'video' => 'Show Video Player'),
                'description' => __('How should the output be formatted? None is default.', 'et_builder'),
                'toggle_slug' => 'main_settings',
            ),
            'admin_label' => array(
                'label' => esc_html__('Admin Label', 'et_builder'),
                'type' => 'text',
                'description' => esc_html__('This will change the label of the module in the builder for easy identification.', 'et_builder'),
                'toggle_slug' => 'main_settings',
            ),
            'module_id' => array(
                'label' => esc_html__('CSS ID', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'tab_slug' => 'custom_css',
                'option_class' => 'et_pb_custom_css_regular',
            ),
            'module_class' => array(
                'label' => esc_html__('CSS Class', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'tab_slug' => 'custom_css',
                'option_class' => 'et_pb_custom_css_regular',
            ),
        );
        return $fields;
    }

    function shortcode_callback($atts, $content = null, $function_name)
    {
        if (!function_exists('get_field') || is_admin()) {
            return;
        }

        $module_id = $this->shortcode_atts['module_id'];
        $module_class = $this->shortcode_atts['module_class'];
        $image_size = $this->shortcode_atts['image_size'];
        $date_format = ($this->shortcode_atts['date_format'] ? $this->shortcode_atts['date_format'] : get_option('date_format'));
        $field = $this->shortcode_atts['field_name'];
        $link_image = $this->shortcode_atts['link_image'];

        $title = $this->shortcode_atts['title'];

        $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);

        //////////////////////////////////////////////////////////////////////

        $output = '';
        $content = '';

        if ($field_arr = explode('|', $field)) {
            $field = $field_arr[1];
        }

        if ($field = get_field_object($field)) {

            //$non_tabular_types = array('repeater');

            if ($title) {
                $content .= '<h2 itemprop="name" class="acf_label">' . $title . '</h2>';
            }

            $value = sb_mod_acf_parse_value_by_type($field, $image_size, false, $date_format, $link_image);

            if ($this->shortcode_atts['format_output']) {
                switch ($this->shortcode_atts['format_output']) {
                    case 'autop':
                        $value = wpautop($value);
                        break;
                    case 'audio':
                        $value = do_shortcode('[audio src="' . $value . '"]');
                        break;
                    case 'video':
                        $value = do_shortcode('[video src="' . $value . '"]');
                        break;
                }
            }

            if (trim($value)) {
                $content .= '<div class="sb_mod_acf_single_item clearfix">' . $value . '</div>';
            } else {
                $content = '';
            }
        }

        //////////////////////////////////////////////////////////////////////

        if (trim($content) && trim($value)) {
            $output = sprintf(
                '<div%5$s class="%1$s%3$s%6$s">
												%2$s
										%4$s',
                'clearfix ',
                $content,
                esc_attr('et_pb_module'),
                '</div>',
                ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
                ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : '')
            );
        }

        return $output;
    }
}

new et_pb_acf_single;

?>